/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Softening;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.entities.ModelingEntity;
import org.xcsp.modeler.entities.VarEntities;

public final class CtrEntities {
    public List<CtrEntity> allEntities = new ArrayList<CtrEntity>();
    public Map<ICtr, CtrAlone> ctrToCtrAlone = new HashMap<ICtr, CtrAlone>();
    public Map<ICtr, CtrArray> ctrToCtrArray = new HashMap<ICtr, CtrArray>();

    public CtrArray newCtrArrayEntity(ICtr[] ctrs, boolean dummy, Types.TypeClass ... classes) {
        return ctrs.length == 0 || dummy ? new CtrArrayDummy(ctrs, classes) : new CtrArray(ctrs, classes);
    }

    public String toString() {
        return this.allEntities.stream().map(ce -> ce.getClass().getSimpleName()).collect(Collectors.joining(" "));
    }

    public final class CtrArrayDummy
    extends CtrArray
    implements ModelingEntity.TagDummy {
        protected CtrArrayDummy(ICtr[] ctrs, Types.TypeClass ... classes) {
            super(ctrs, classes);
            Stream.of(ctrs).forEach(c -> CtrEntities.this.ctrToCtrAlone.get(c).tag(classes));
        }

        @Override
        public CtrArrayDummy note(String note) {
            Stream.of(this.ctrs).forEach(c -> CtrEntities.this.ctrToCtrAlone.get(c).note(note));
            return this;
        }

        @Override
        public CtrArrayDummy tag(Types.TypeClass ... classes) {
            Stream.of(this.ctrs).forEach(c -> CtrEntities.this.ctrToCtrAlone.get(c).tag(classes));
            this.varEntitiessSubjectToTags.stream().forEach(x -> x.tag(classes));
            return this;
        }
    }

    public class CtrArray
    extends CtrEntity {
        public ICtr[] ctrs;
        public List<VarEntities.VarEntity> varEntitiessSubjectToTags;

        public CtrArray(ICtr[] ctrs, Types.TypeClass ... classes) {
            super(classes);
            this.ctrs = ctrs;
            if (!(this instanceof CtrArrayDummy)) {
                Stream.of(ctrs).forEach(c -> CtrEntities.this.ctrToCtrArray.put((ICtr)c, this));
            }
        }

        @Override
        public CtrEntity violationCost(int violationCost) {
            System.out.println("Not possible to associate a violation cost with a group of constraints");
            return null;
        }

        public CtrArray append(CtrArray ca) {
            Utilities.control(ca.id == null && ca.note == null && ca.classes.size() == 0, "Implementation not finished yet to take into account such situations where some information must be merged");
            this.ctrs = (ICtr[])Utilities.convert(IntStream.range(0, this.ctrs.length + ca.ctrs.length).mapToObj(i -> i < this.ctrs.length ? this.ctrs[i] : ca.ctrs[i - this.ctrs.length]).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CtrArray tag(Types.TypeClass ... classes) {
            super.tag(classes);
            this.varEntitiessSubjectToTags.stream().forEach(x -> x.tag(classes));
            return this;
        }
    }

    public final class CtrAloneDummy
    extends CtrAlone
    implements ModelingEntity.TagDummy {
        public CtrAloneDummy(String note, Types.TypeClass ... classes) {
            super(classes);
            this.note(note);
        }
    }

    public class CtrAlone
    extends CtrEntity {
        public ICtr ctr;
        public Softening softening;

        public CtrAlone(Types.TypeClass ... classes) {
            super(classes);
        }

        public CtrAlone(ICtr ctr, Types.TypeClass ... classes) {
            this(classes);
            this.ctr = ctr;
            this$0.ctrToCtrAlone.put(ctr, this);
            Utilities.control(ctr != null && !(this instanceof CtrAloneDummy), "CtrAloneDummy possible only iff the specified constraint is null.In some implementations other than default one, it could be different.");
        }

        @Override
        public CtrEntity violationCost(int violationCost) {
            return null;
        }
    }

    public abstract class CtrEntity
    extends ModelingEntity {
        protected CtrEntity(Types.TypeClass ... classes) {
            super(classes);
            CtrEntities.this.allEntities.add(this);
        }

        public abstract CtrEntity violationCost(int var1);
    }
}

