/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.problems;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Rack
implements ProblemAPI {
    int nRacks;
    int[][] models;
    int[][] cardTypes;

    @Override
    public void model() {
        this.models = this.addObject((T[])this.models, this.tuple(0, 0, 0), 0);
        int nModels = this.models.length;
        int nTypes = this.cardTypes.length;
        int[] powers = this.columnOf(this.models, 0);
        int[] connectors = this.columnOf(this.models, 1);
        int[] prices = this.columnOf(this.models, 2);
        int[] cardPowers = this.columnOf(this.cardTypes, 0);
        int maxCapacity = this.maxOf(connectors);
        IVar.Var[] r = this.array("r", this.size(this.nRacks), this.dom(this.range(nModels)), "r[i] is the model used for the ith rack", new Types.TypeClass[0]);
        IVar.Var[][] c = this.array("c", this.size(this.nRacks, nTypes), (int i, int j) -> this.dom(this.range(Math.min(maxCapacity, this.cardTypes[j][1]) + 1)), "c[i][j] is the number of cards of type j put in the ith rack", new Types.TypeClass[0]);
        IVar.Var[] rpw = this.array("rpw", this.size(this.nRacks), this.dom(powers), "rpw[i] is the power of the ith rack", new Types.TypeClass[0]);
        IVar.Var[] rcn = this.array("rcn", this.size(this.nRacks), this.dom(connectors), "rcn[i] is the number of connectors of the ith rack", new Types.TypeClass[0]);
        IVar[] rpr = this.array("rpr", this.size(this.nRacks), this.dom(prices), "rpr[i] is the price of the ith rack", new Types.TypeClass[0]);
        this.forall(this.range(this.nRacks), (int i) -> this.extension((IVar.Var[])this.vars(r[i], rpw[i]), this.indexing(powers))).note("linking the ith rack with its power");
        this.forall(this.range(this.nRacks), (int i) -> this.extension((IVar.Var[])this.vars(r[i], rcn[i]), this.indexing(connectors))).note("linking the ith rack with its number of connectors");
        this.forall(this.range(this.nRacks), arg_0 -> this.lambda$model$3(r, (IVar.Var[])rpr, prices, arg_0)).note("linking the ith rack with its price");
        this.forall(this.range(this.nRacks), (int i) -> this.sum(c[i], LE, rcn[i])).note("connector-capacity constraints");
        this.forall(this.range(this.nRacks), (int i) -> this.sum(c[i], this.weightedBy(cardPowers), LE, rpw[i])).note("power-capacity constraints");
        this.forall(this.range(nTypes), (int i) -> this.sum(this.columnOf(c, i), EQ, (long)this.cardTypes[i][1])).note("demand constraints");
        this.block(() -> {
            this.decreasing(r);
            this.disjunction(this.ne(r[0], r[1]), this.ge(c[0][0], c[1][0]));
        }).tag(SYMMETRY_BREAKING);
        this.minimize(SUM, rpr);
    }

    private /* synthetic */ void lambda$model$3(IVar.Var[] r, IVar.Var[] rpr, int[] prices, int i) {
        this.extension((IVar.Var[])this.vars(r[i], rpr[i]), this.indexing(prices));
    }
}

