/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.problems;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Warehouse
implements ProblemAPI {
    int fixedCost;
    int[] warehouseCapacities;
    int[][] storeSupplyCosts;

    @Override
    public void model() {
        int nWarehouses = this.warehouseCapacities.length;
        int nStores = this.storeSupplyCosts.length;
        IVar.Var[] sw = this.array("sw", this.size(nStores), this.dom(this.range(nWarehouses)), "sw[i] is the supplying warehouse for the ith store", new Types.TypeClass[0]);
        IVar.Var[] sc = this.array("sc", this.size(nStores), (int i) -> this.dom(this.storeSupplyCosts[i]), "sc[i] is the supplying cost for the ith store", new Types.TypeClass[0]);
        IVar[] open = this.array("open", this.size(nWarehouses), this.dom(0, 1), "open[i] is 1 if the ith warehouse is open", new Types.TypeClass[0]);
        this.forall(this.range(nWarehouses), (int i) -> this.atMost(sw, this.takingValue(i), this.warehouseCapacities[i])).note("Capacities of warehouses must not be exceeded.");
        this.forall(this.range(nStores), arg_0 -> this.lambda$model$2((IVar.Var[])open, sw, arg_0)).note("The warehouse supplier of the ith store must be open.");
        this.forall(this.range(nStores), (int i) -> this.element(this.storeSupplyCosts[i], this.at(sw[i]), this.condition(EQ, sc[i]))).note("Computing the cost of supplying the ith store.");
        int[] coeffs = this.vals(this.repeat(1, nStores), this.repeat(this.fixedCost, nWarehouses));
        this.minimize(SUM, this.vars(sc, open), this.weightedBy(coeffs)).note("minimizing the overall cost");
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[] open, IVar.Var[] sw, int i) {
        this.element(open, this.at(sw[i]), this.condition(EQ, 1L));
    }
}

