/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.entries;

import java.util.LinkedHashSet;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.XNode;
import org.xcsp.parser.entries.ParsingEntry;
import org.xcsp.parser.entries.XVariables;

public class XObjectives {

    public static final class OObjectiveSpecial
    extends XObj {
        public final Object[] terms;
        public final Values.SimpleValue[] coeffs;

        public OObjectiveSpecial(boolean minimize, Types.TypeObjective type, Object[] terms, Values.SimpleValue[] coeffs) {
            super(minimize, type);
            this.terms = terms;
            this.coeffs = coeffs;
        }

        @Override
        public XVariables.XVar[] vars() {
            if (this.terms[0] instanceof IVar) {
                return (XVariables.XVar[])this.terms;
            }
            LinkedHashSet<IVar> set = new LinkedHashSet<IVar>();
            for (Object term : this.terms) {
                if (term instanceof IVar) {
                    set.add((IVar)term);
                    continue;
                }
                assert (term instanceof XNode);
                ((XNode)term).listOfVars().stream().forEach(x -> set.add((IVar)x));
            }
            return set.size() == 0 ? null : (XVariables.XVar[])set.stream().toArray(s -> (XVariables.XVar[])Utilities.buildArray(((IVar)set.iterator().next()).getClass(), s));
        }

        @Override
        public String toString() {
            return super.toString() + "\n" + Utilities.join(this.terms) + (this.coeffs != null ? "\n" + Utilities.join(this.coeffs) : "");
        }
    }

    public static final class OObjectiveExpr
    extends XObj {
        public final XNode<? extends XVariables.XVar> rootNode;

        public OObjectiveExpr(boolean minimize, Types.TypeObjective type, XNode<? extends XVariables.XVar> rootNode) {
            super(minimize, type);
            this.rootNode = rootNode;
        }

        @Override
        public XVariables.XVar[] vars() {
            return (XVariables.XVar[])this.rootNode.vars();
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.rootNode.toString();
        }
    }

    public static abstract class XObj
    extends ParsingEntry.OEntry {
        public XObj(boolean minimize, Types.TypeObjective type) {
            super(minimize, type);
        }
    }
}

