/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.entries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.domains.Values;
import org.xcsp.parser.XParser;
import org.xcsp.parser.entries.ParsingEntry;

public class XVariables {
    public static final String OTHERS = "others";

    public static final class XArray
    extends ParsingEntry.VEntry {
        public final int[] size;
        public final XVar[] vars;

        public XArray(String id, Types.TypeVar type, int[] size) {
            super(id, type);
            this.size = size;
            this.vars = new XVar[Arrays.stream(size).reduce(1, (s, t) -> s * t)];
        }

        private void buildVarsWith(Domains.IDom dom) {
            int[] indexes = new int[this.size.length];
            block0: for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i] == null) {
                    this.vars[i] = XVar.build(this.id, this.type, dom, indexes);
                }
                for (int j = indexes.length - 1; j >= 0; --j) {
                    int n = j;
                    indexes[n] = indexes[n] + 1;
                    if (indexes[n] != this.size[j]) continue block0;
                    indexes[j] = 0;
                }
            }
        }

        public XArray(String id, Types.TypeVar type, int[] sizes, Domains.IDom dom) {
            this(id, type, sizes);
            this.buildVarsWith(dom);
        }

        protected int[] indexesFor(int flatIndex) {
            int[] t = new int[this.size.length];
            for (int i = t.length - 1; i > 0; --i) {
                t[i] = flatIndex % this.size[i];
                flatIndex /= this.size[i];
            }
            t[0] = flatIndex;
            return t;
        }

        private int flatIndexFor(int ... indexes) {
            int sum = 0;
            int nb = 1;
            for (int i = indexes.length - 1; i >= 0; --i) {
                sum += indexes[i] * nb;
                nb *= this.size[i];
            }
            return sum;
        }

        public XVar varAt(int ... indexes) {
            return this.vars[this.flatIndexFor(indexes)];
        }

        public Domains.Dom domAt(int ... indexes) {
            XVar x = this.vars[this.flatIndexFor(indexes)];
            return x == null || x.degree == 0 ? null : (Domains.Dom)x.dom;
        }

        public Values.IntegerEntity[] buildIndexRanges(String compactForm) {
            Values.IntegerEntity[] t = new Values.IntegerEntity[this.size.length];
            String suffix = compactForm.substring(compactForm.indexOf("["));
            for (int i = 0; i < t.length; ++i) {
                int pos = suffix.indexOf("]");
                String tok = suffix.substring(1, pos);
                t[i] = tok.length() == 0 ? new Values.IntegerInterval(0L, this.size[i] - 1) : Values.IntegerEntity.parse(tok);
                suffix = suffix.substring(pos + 1);
            }
            return t;
        }

        private boolean incrementIndexes(int[] indexes, Values.IntegerEntity[] indexRanges) {
            int j;
            for (j = indexes.length - 1; j >= 0; --j) {
                if (indexRanges[j].isSingleton()) continue;
                int n = j;
                indexes[n] = indexes[n] + 1;
                if ((long)indexes[n] <= ((Values.IntegerInterval)indexRanges[j]).sup) break;
                indexes[j] = (int)((Values.IntegerInterval)indexRanges[j]).inf;
            }
            return j >= 0;
        }

        public void setDom(String s, Domains.IDom dom) {
            if (s.trim().equals(XVariables.OTHERS)) {
                this.buildVarsWith(dom);
            } else {
                for (String tok : s.split("\\s+")) {
                    Utilities.control(tok.substring(0, tok.indexOf("[")).equals(this.id), "One value of attribute 'for' incorrect in array " + this.id);
                    Values.IntegerEntity[] indexRanges = this.buildIndexRanges(tok);
                    int[] indexes = Stream.of(indexRanges).mapToInt(it -> (int)it.smallest()).toArray();
                    do {
                        int flatIndex;
                        Utilities.control(this.vars[flatIndex = this.flatIndexFor(indexes)] == null, "Problem with two domain definitions for the same variable");
                        this.vars[flatIndex] = XVar.build(this.id, this.type, dom, indexes);
                    } while (this.incrementIndexes(indexes, indexRanges));
                }
            }
        }

        public List<XVar> getVarsFor(String compactForm) {
            ArrayList<XVar> list = new ArrayList<XVar>();
            Values.IntegerEntity[] indexRanges = this.buildIndexRanges(compactForm);
            int[] indexes = Stream.of(indexRanges).mapToInt(it -> (int)it.smallest()).toArray();
            do {
                list.add(this.vars[this.flatIndexFor(indexes)]);
            } while (this.incrementIndexes(indexes, indexRanges));
            return list;
        }

        @Override
        public String toString() {
            return super.toString() + " [" + Utilities.join(this.size, "][") + "] " + Utilities.join(this.vars, " ");
        }
    }

    public static final class XVarSet
    extends XVar {
        protected XVarSet(String id, Types.TypeVar type, Domains.IDom dom) {
            super(id, type, dom);
        }
    }

    public static final class XVarReal
    extends XVar {
        protected XVarReal(String id, Types.TypeVar type, Domains.IDom dom) {
            super(id, type, dom);
        }
    }

    public static final class XVarStochastic
    extends XVar {
        protected XVarStochastic(String id, Types.TypeVar type, Domains.IDom dom) {
            super(id, type, dom);
        }
    }

    public static final class XVarSymbolic
    extends XVar
    implements IVar.VarSymbolic {
        protected XVarSymbolic(String id, Types.TypeVar type, Domains.IDom dom) {
            super(id, type, dom);
        }
    }

    public static final class XVarInteger
    extends XVar
    implements IVar.Var {
        public static long domainCartesianProductSize(XVarInteger[] scp) {
            long[] domSizes = Stream.of(scp).mapToLong(x -> Values.IntegerEntity.nValues((Values.IntegerEntity[])((Domains.Dom)x.dom).values)).toArray();
            if (LongStream.of(domSizes).anyMatch(l -> l == -1L)) {
                return -1L;
            }
            long cnt = 1L;
            try {
                for (long size : domSizes) {
                    cnt = Math.multiplyExact(cnt, size);
                }
            }
            catch (ArithmeticException e) {
                return -1L;
            }
            return cnt;
        }

        public XParser.TypePrimitive whichPrimitive() {
            return XParser.TypePrimitive.whichPrimitiveFor(this.firstValue(), this.lastValue());
        }

        protected XVarInteger(String id, Types.TypeVar type, Domains.IDom dom) {
            super(id, type, dom);
        }

        public long firstValue() {
            return ((Domains.Dom)this.dom).firstValue();
        }

        public long lastValue() {
            return ((Domains.Dom)this.dom).lastValue();
        }

        @Override
        public Object allValues() {
            return ((Domains.Dom)this.dom).allValues();
        }

        public boolean isZeroOne() {
            return this.firstValue() == 0L && this.lastValue() == 1L;
        }
    }

    public static abstract class XVar
    extends ParsingEntry.VEntry
    implements IVar {
        public final Domains.IDom dom;
        public int degree;

        public static final XVar build(String id, Types.TypeVar type, Domains.IDom dom) {
            switch (type) {
                case integer: {
                    return new XVarInteger(id, type, dom);
                }
                case symbolic: {
                    return new XVarSymbolic(id, type, dom);
                }
                case stochastic: {
                    return new XVarStochastic(id, type, dom);
                }
                case real: {
                    return new XVarReal(id, type, dom);
                }
                case set: {
                    return new XVarSet(id, type, dom);
                }
            }
            throw new RuntimeException("Unimplemented case ");
        }

        public static final XVar build(String idArray, Types.TypeVar type, Domains.IDom dom, int[] indexes) {
            return XVar.build(idArray + "[" + Utilities.join(indexes, "][") + "]", type, dom);
        }

        protected XVar(String id, Types.TypeVar type, Domains.IDom dom) {
            super(id, type);
            this.dom = dom;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String toString() {
            return this.id;
        }
    }
}

