/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.xenei.classpathutils.filter.AbstractClassFilter;
import org.xenei.classpathutils.filter.AnnotationClassFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter.InterfaceClassFilter;
import org.xenei.classpathutils.filter.TrueClassFilter;

public interface ClassPathFilter {
    public static final ClassPathFilter TRUE = TrueClassFilter.TRUE;
    public static final ClassPathFilter FALSE = FalseClassFilter.FALSE;
    public static final ClassPathFilter ANNOTATION_CLASS = AnnotationClassFilter.ANNOTATION;
    public static final ClassPathFilter ABSTRACT_CLASS = AbstractClassFilter.ABSTRACT;
    public static final ClassPathFilter INTERFACE_CLASS = InterfaceClassFilter.INTERFACE;

    public ClassPathFilter optimize();

    public boolean accept(URL var1);

    public boolean accept(String var1);

    public boolean accept(Class<?> var1);

    public String funcName();

    public Collection<URL> filterURLs(Collection<URL> var1);

    public Collection<String> filterNames(Collection<String> var1);

    public Collection<Class<?>> filterClasses(Collection<Class<?>> var1);

    public String[] args();

    public static class Util {
        public static Collection<URL> filterURLs(Collection<URL> urls, ClassPathFilter filter) {
            ArrayList<URL> retval = new ArrayList<URL>();
            for (URL url : urls) {
                if (!filter.accept(url)) continue;
                retval.add(url);
            }
            return retval;
        }

        public static Collection<String> filterNames(Collection<String> classNames, ClassPathFilter filter) {
            ArrayList<String> retval = new ArrayList<String>();
            for (String className : classNames) {
                if (!filter.accept(className)) continue;
                retval.add(className);
            }
            return retval;
        }

        public static Collection<Class<?>> filterClasses(Collection<Class<?>> classes, ClassPathFilter filter) {
            ArrayList retval = new ArrayList();
            for (Class<?> clazz : classes) {
                if (!filter.accept(clazz)) continue;
                retval.add(clazz);
            }
            return retval;
        }

        public static String toString(ClassPathFilter filter) {
            StringBuilder sb = new StringBuilder(filter.funcName()).append("(");
            String[] args = filter.args();
            if (args.length > 0) {
                sb.append(" ");
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(args[i]);
                }
                sb.append(" ");
            }
            return sb.append(")").toString();
        }

        public static boolean equals(ClassPathFilter cpf1, ClassPathFilter cpf2) {
            return cpf1.toString().equals(cpf2.toString());
        }

        public static int hashCode(ClassPathFilter cpf) {
            return cpf.toString().hashCode();
        }

        public static String parseArgs(String str, int pos) {
            int cnt = 1;
            block4: for (int i = pos + 1; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case '(': {
                        ++cnt;
                        continue block4;
                    }
                    case ')': {
                        if (--cnt != 0) continue block4;
                        return str.substring(pos, i - 1);
                    }
                }
            }
            throw new IllegalArgumentException("Can not parse " + str);
        }
    }
}

