/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.Case;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter._AbstractStringFilter;

public class NameClassFilter
extends _AbstractStringFilter
implements Serializable {
    private static final Log LOG = LogFactory.getLog(NameClassFilter.class);
    private static final long serialVersionUID = 2314511406134237664L;

    public NameClassFilter(String name) {
        super(name);
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    public NameClassFilter(Case caseSensitivity, String name) {
        super(caseSensitivity, name);
    }

    public NameClassFilter(String ... names) {
        super(names);
    }

    public NameClassFilter(Case caseSensitivity, String ... names) {
        super(caseSensitivity, names);
    }

    public NameClassFilter(Collection<String> names) {
        super(names);
    }

    public NameClassFilter(Case caseSensitivity, Collection<String> names) {
        super(caseSensitivity, names);
    }

    @Override
    public boolean accept(String className) {
        String cn = NameClassFilter.removeDotClass(className);
        for (String name2 : this.getStrings()) {
            if (!this.caseSensitivity.checkEquals(cn, name2)) continue;
            return true;
        }
        return false;
    }

    public NameClassFilter addClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        super.addString(clazz.getName());
        return this;
    }

    public final NameClassFilter addClasses(Collection<Class<?>> classes) {
        if (classes == null) {
            throw new IllegalArgumentException("The classes parameter must not be null");
        }
        for (Class<?> c : classes) {
            this.addClass(c);
        }
        return this;
    }

    public final NameClassFilter addClasses(Class<?> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException("The classes parameter must not be null");
        }
        for (Class<?> c : classes) {
            this.addClass(c);
        }
        return this;
    }

    @Override
    public ClassPathFilter optimize() {
        LinkedHashSet<String> lst = new LinkedHashSet<String>(this.getStrings());
        if (lst.size() == 0) {
            return FalseClassFilter.FALSE;
        }
        if (lst.size() < this.getStrings().size()) {
            return new NameClassFilter(lst);
        }
        return this;
    }
}

