/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import org.xenei.classpathutils.Case;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.types.StringFilterType;

public class RegexClassFilter
implements ClassPathFilter,
Serializable,
StringFilterType {
    private static final long serialVersionUID = -3282334808113162667L;
    private final Pattern pattern;

    public RegexClassFilter(String pattern) {
        this(Case.SENSITIVE, pattern);
    }

    public RegexClassFilter(Case caseSensitivity, String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        int flags = 0;
        if (caseSensitivity != null && !caseSensitivity.isCaseSensitive()) {
            flags = 2;
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    public RegexClassFilter(String pattern, int flags) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    public RegexClassFilter(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.pattern = pattern;
    }

    @Override
    public String funcName() {
        return "Regex";
    }

    @Override
    public boolean accept(String className) {
        return this.pattern.matcher(className).matches();
    }

    @Override
    public boolean accept(URL url) {
        return this.accept(url.toExternalForm());
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return this.accept(clazz.getName());
    }

    public String toString() {
        return ClassPathFilter.Util.toString(this);
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPathFilter) {
            return ClassPathFilter.Util.equals(this, (ClassPathFilter)o);
        }
        return false;
    }

    public int hashCode() {
        return ClassPathFilter.Util.hashCode(this);
    }

    @Override
    public String[] args() {
        Case c = (this.pattern.flags() & 2) != 0 ? Case.INSENSITIVE : Case.SENSITIVE;
        return new String[]{c.getName(), this.pattern.pattern()};
    }

    @Override
    public Collection<URL> filterURLs(Collection<URL> collection) {
        return ClassPathFilter.Util.filterURLs(collection, this);
    }

    @Override
    public Collection<String> filterNames(Collection<String> collection) {
        return ClassPathFilter.Util.filterNames(collection, this);
    }

    @Override
    public Collection<Class<?>> filterClasses(Collection<Class<?>> collection) {
        return ClassPathFilter.Util.filterClasses(collection, this);
    }

    @Override
    public ClassPathFilter optimize() {
        return this;
    }
}

