/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.Case;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter.TrueClassFilter;
import org.xenei.classpathutils.filter._AbstractStringFilter;

public class SuffixClassFilter
extends _AbstractStringFilter
implements Serializable {
    private static final Log LOG = LogFactory.getLog(SuffixClassFilter.class);
    private static final long serialVersionUID = 525854048564445111L;

    public SuffixClassFilter(String suffix) {
        super(suffix);
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    public SuffixClassFilter(Case caseSensitivity, String suffix) {
        super(caseSensitivity, suffix);
    }

    public SuffixClassFilter(String ... suffixes) {
        super(suffixes);
    }

    public SuffixClassFilter(Case caseSensitivity, String ... suffixes) {
        super(caseSensitivity, suffixes);
    }

    public SuffixClassFilter(Collection<String> suffixes) {
        super(suffixes);
    }

    public SuffixClassFilter(Case caseSensitivity, Collection<String> suffixes) {
        super(caseSensitivity, suffixes);
    }

    @Override
    public boolean accept(String className) {
        for (String suffix : this.getStrings()) {
            if (!this.caseSensitivity.checkEndsWith(className, suffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassPathFilter optimize() {
        LinkedHashSet<String> set = new LinkedHashSet<String>(this.getStrings());
        if (set.size() == 0) {
            return FalseClassFilter.FALSE;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (((String)iter.next()).length() != 0) continue;
            return TrueClassFilter.TRUE;
        }
        if (set.size() < this.getStrings().size()) {
            return new SuffixClassFilter(this.caseSensitivity, set);
        }
        return this;
    }
}

