/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.types.CollectionFilterType;
import org.xenei.classpathutils.filter.types.LogicFilterType;
import org.xenei.classpathutils.filter.types.StringFilterType;

public abstract class _AbstractConditionalFilter
implements CollectionFilterType {
    protected static final Comparator<ClassPathFilter> EXECUTION_ORDER = new Comparator<ClassPathFilter>(){

        private ClassPathFilter getFilter(ClassPathFilter f) {
            if (f instanceof CollectionFilterType) {
                List<ClassPathFilter> l = ((CollectionFilterType)f).getFilters();
                if (l.size() != 1) {
                    return f;
                }
                return l.get(0);
            }
            return f;
        }

        private int getFilterValue(ClassPathFilter f) {
            if (f instanceof StringFilterType) {
                return 1;
            }
            if (f instanceof LogicFilterType) {
                return 0;
            }
            if (f instanceof CollectionFilterType) {
                return 10;
            }
            return 100;
        }

        @Override
        public int compare(ClassPathFilter arg0, ClassPathFilter arg1) {
            return Integer.compare(this.getFilterValue(this.getFilter(arg0)), this.getFilterValue(this.getFilter(arg1)));
        }
    };
    private final List<ClassPathFilter> classFilters = new ArrayList<ClassPathFilter>();

    protected _AbstractConditionalFilter(Collection<ClassPathFilter> classFilters) {
        if (classFilters == null || classFilters.size() < 2) {
            throw new IllegalArgumentException("Collection of filters may not be null or contain less than 2 filters");
        }
        this.addFilters(classFilters);
    }

    protected _AbstractConditionalFilter(ClassPathFilter ... classFilters) {
        if (classFilters.length < 2) {
            throw new IllegalArgumentException("Array of filters may not contain less than 2 filters");
        }
        this.addFilters(classFilters);
    }

    @Override
    public String[] args() {
        String[] retval = new String[this.classFilters.size()];
        for (int i = 0; i < this.classFilters.size(); ++i) {
            retval[i] = this.classFilters.get(i).toString();
        }
        return retval;
    }

    @Override
    public Collection<URL> filterURLs(Collection<URL> collection) {
        return ClassPathFilter.Util.filterURLs(collection, this);
    }

    @Override
    public Collection<String> filterNames(Collection<String> collection) {
        return ClassPathFilter.Util.filterNames(collection, this);
    }

    @Override
    public Collection<Class<?>> filterClasses(Collection<Class<?>> collection) {
        return ClassPathFilter.Util.filterClasses(collection, this);
    }

    protected boolean isFilterListEmpty() {
        return this.classFilters.isEmpty();
    }

    public final _AbstractConditionalFilter addFilter(ClassPathFilter classFilter) {
        if (classFilter == null) {
            throw new IllegalArgumentException("classFilter may not be null");
        }
        this.classFilters.add(classFilter);
        return this;
    }

    @Override
    public final List<ClassPathFilter> getFilters() {
        return Collections.unmodifiableList(this.classFilters);
    }

    public final boolean removeFilter(ClassPathFilter classFilter) {
        return this.classFilters.remove(classFilter);
    }

    public final void setFilters(Collection<ClassPathFilter> classFilters) {
        this.classFilters.clear();
        this.addFilters(classFilters);
    }

    public final void addFilters(Collection<ClassPathFilter> classFilters) {
        for (ClassPathFilter filter : classFilters) {
            this.addFilter(filter);
        }
    }

    public final void setFilters(ClassPathFilter ... classFilters) {
        this.classFilters.clear();
        this.addFilters(classFilters);
    }

    public final void addFilters(ClassPathFilter ... classFilters) {
        for (ClassPathFilter filter : classFilters) {
            this.addFilter(filter);
        }
    }

    public final void removeFilters(Collection<ClassPathFilter> classFilters) {
        this.classFilters.removeAll(classFilters);
    }

    public final void removeFilters(ClassPathFilter ... classFilters) {
        this.classFilters.removeAll(Arrays.asList(classFilters));
    }

    public String toString() {
        return ClassPathFilter.Util.toString(this);
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPathFilter) {
            return ClassPathFilter.Util.equals(this, (ClassPathFilter)o);
        }
        return false;
    }

    public int hashCode() {
        return ClassPathFilter.Util.hashCode(this);
    }
}

