/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xenei.classpathutils.Case;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter._AbstractBaseFilter;
import org.xenei.classpathutils.filter.types.StringFilterType;

public abstract class _AbstractStringFilter
extends _AbstractBaseFilter
implements StringFilterType {
    private final List<String> strings = new ArrayList<String>();
    protected final Case caseSensitivity;

    protected _AbstractStringFilter(String str) {
        this((Case)null, str);
    }

    protected _AbstractStringFilter(Case caseSensitivity, String str) {
        this.caseSensitivity = caseSensitivity == null ? Case.SENSITIVE : caseSensitivity;
        this.addString(str);
    }

    protected _AbstractStringFilter(String ... strings) {
        this((Case)null, strings);
    }

    protected _AbstractStringFilter(Case caseSensitivity, String ... strings) {
        Case case_ = this.caseSensitivity = caseSensitivity == null ? Case.SENSITIVE : caseSensitivity;
        if (strings != null && strings.length > 0) {
            this.addStrings(strings);
        }
    }

    protected _AbstractStringFilter(Collection<String> strings) {
        this((Case)null, strings.toArray(new String[strings.size()]));
    }

    protected _AbstractStringFilter(Case caseSensitivity, Collection<String> strings) {
        this(caseSensitivity, strings.toArray(new String[strings.size()]));
    }

    @Override
    public String[] args() {
        String[] retval = new String[this.strings.size() + 1];
        retval[0] = this.caseSensitivity.getName();
        this.strings.sort(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < this.strings.size(); ++i) {
            retval[i + 1] = this.strings.get(i);
        }
        return retval;
    }

    public final void addString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        this.strings.add(str);
    }

    public final void addStrings(Collection<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException("The strings must not be null");
        }
        for (String s : strings) {
            this.addString(s);
        }
    }

    public final void addStrings(String ... strings) {
        if (strings == null) {
            throw new IllegalArgumentException("The strings must not be null");
        }
        for (String s : strings) {
            this.addString(s);
        }
    }

    public final List<String> getStrings() {
        return Collections.unmodifiableList(this.strings);
    }

    @Override
    public boolean accept(URL url) {
        return this.accept(url.toExternalForm());
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return this.accept(clazz.getName());
    }

    @Override
    public String toString() {
        return ClassPathFilter.Util.toString(this);
    }
}

