/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;
import org.xenei.classpathutils.filter.HasAnnotationClassFilter;
import org.xenei.classpathutils.filter.NameClassFilter;
import org.xenei.classpathutils.filter.OrClassFilter;
import org.xenei.classpathutils.filter.types.FilterType;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractExclude;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.ContractTest;
import org.xenei.junit.contract.ContractTestRunner;
import org.xenei.junit.contract.Dynamic;
import org.xenei.junit.contract.info.ContractTestMap;
import org.xenei.junit.contract.info.DynamicSuiteInfo;
import org.xenei.junit.contract.info.DynamicTestInfo;
import org.xenei.junit.contract.info.SuiteInfo;
import org.xenei.junit.contract.info.TestInfo;
import org.xenei.junit.contract.info.TestInfoErrorRunner;

public class ContractSuite
extends ParentRunner<Runner> {
    private static final Log LOG = LogFactory.getLog(ContractSuite.class);
    private final List<Runner> fRunners;

    public ContractSuite(Class<?> contractTest, RunnerBuilder builder) throws InitializationError, InstantiationException, IllegalAccessException {
        super(contractTest);
        List<TestInfoErrorRunner> runners;
        ContractTestMap contractTestMap;
        TestInfo testInfo;
        ContractImpl contractImpl = contractTest.getAnnotation(ContractImpl.class);
        FilterType ignoreFilter = new HasAnnotationClassFilter(Ignore.class);
        if (contractImpl.ignore().length > 0) {
            ArrayList<String> lst = new ArrayList<String>();
            for (Class<?> c : contractImpl.ignore()) {
                lst.add(c.getName());
            }
            ignoreFilter = new OrClassFilter(ignoreFilter, new NameClassFilter(lst));
        }
        if ((testInfo = (contractTestMap = new ContractTestMap(ignoreFilter)).getInfoByTestClass(contractTest)) != null && testInfo.hasErrors()) {
            runners = new ArrayList<TestInfoErrorRunner>();
            runners.add(new TestInfoErrorRunner(contractTest, testInfo));
        } else {
            Object baseObj = contractTest.newInstance();
            runners = baseObj instanceof Dynamic ? this.addDynamicClasses(builder, contractTestMap, (Dynamic)baseObj) : this.addAnnotatedClasses(contractTest, builder, contractTestMap, baseObj);
        }
        this.fRunners = Collections.unmodifiableList(runners);
    }

    private ContractImpl getContractImpl(Class<?> cls) throws InitializationError {
        ContractImpl impl = cls.getAnnotation(ContractImpl.class);
        if (impl == null) {
            throw new InitializationError("Classes annotated as @RunWith( ContractSuite ) [" + cls + "] must also be annotated with @ContractImpl");
        }
        return impl;
    }

    private List<Method> getExcludedMethods(Class<?> cls) {
        ArrayList<Method> lst = new ArrayList<Method>();
        for (ContractExclude exclude : (ContractExclude[])cls.getAnnotationsByType(ContractExclude.class)) {
            Class<?> clazz = exclude.value();
            for (String mthdName : exclude.methods()) {
                try {
                    lst.add(clazz.getDeclaredMethod(mthdName, new Class[0]));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    LOG.warn((Object)String.format("ContractExclude annotation on %s incorrect", cls), (Throwable)e);
                }
            }
        }
        return lst;
    }

    private List<Runner> addDynamicClasses(RunnerBuilder builder, ContractTestMap contractTestMap, Dynamic dynamic) throws InitializationError {
        Class<?> dynamicClass = dynamic.getClass();
        ArrayList<Runner> runners = new ArrayList<Runner>();
        ContractImpl impl = this.getContractImpl(dynamicClass);
        if (impl == null) {
            return runners;
        }
        DynamicSuiteInfo dynamicSuiteInfo = new DynamicSuiteInfo((Class<? extends Dynamic>)dynamicClass, impl);
        Collection<Class<?>> tests = dynamic.getSuiteClasses();
        if (tests == null || tests.size() == 0) {
            dynamicSuiteInfo.addError((Throwable)new InitializationError("Dynamic suite did not return a list of classes to execute"));
            runners.add(new TestInfoErrorRunner(dynamicClass, dynamicSuiteInfo));
        } else {
            for (Class<?> test : tests) {
                RunWith runwith = test.getAnnotation(RunWith.class);
                if (runwith != null && runwith.value().equals(ContractSuite.class)) {
                    impl = this.getContractImpl(test);
                    if (impl == null) continue;
                    DynamicTestInfo parentTestInfo = new DynamicTestInfo(test, impl, dynamicSuiteInfo);
                    if (!parentTestInfo.hasErrors()) {
                        this.addSpecifiedClasses(runners, test, builder, contractTestMap, dynamic, parentTestInfo);
                    }
                    if (!parentTestInfo.hasErrors()) continue;
                    runners.add(new TestInfoErrorRunner(dynamicClass, parentTestInfo));
                    continue;
                }
                try {
                    runners.add(builder.runnerForClass(test));
                }
                catch (Throwable t) {
                    throw new InitializationError(t);
                }
            }
        }
        return runners;
    }

    private List<Runner> addAnnotatedClasses(Class<?> baseClass, RunnerBuilder builder, ContractTestMap contractTestMap, Object baseObj) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        ContractImpl impl = this.getContractImpl(baseClass);
        if (impl != null) {
            TestInfo testInfo = contractTestMap.getInfoByTestClass(impl.value());
            if (testInfo == null) {
                testInfo = new SuiteInfo(baseClass, impl);
                contractTestMap.add(testInfo);
            }
            if (!testInfo.hasErrors()) {
                this.addSpecifiedClasses(runners, baseClass, builder, contractTestMap, baseObj, testInfo);
            }
            if (testInfo.hasErrors()) {
                runners.add(new TestInfoErrorRunner(baseClass, testInfo));
            }
        }
        return runners;
    }

    private void addSpecifiedClasses(List<Runner> runners, Class<?> testClass, RunnerBuilder builder, ContractTestMap contractTestMap, Object baseObj, TestInfo parentTestInfo) throws InitializationError {
        LinkedHashSet<TestInfo> testClasses = new LinkedHashSet<TestInfo>();
        BaseClassRunner bcr = new BaseClassRunner(testClass);
        if (bcr.computeTestMethods().size() > 0) {
            runners.add((Runner)bcr);
        }
        List<Method> excludeMethods = this.getExcludedMethods(this.getTestClass().getJavaClass());
        for (TestInfo testInfo : contractTestMap.getAnnotatedClasses(testClasses, parentTestInfo)) {
            if (Arrays.asList(parentTestInfo.getSkipTests()).contains(testInfo.getClassUnderTest())) continue;
            if (testInfo.getErrors().size() > 0) {
                TestInfoErrorRunner runner = new TestInfoErrorRunner(testClass, testInfo);
                runner.logErrors(LOG);
                runners.add(runner);
                continue;
            }
            runners.add((Runner)new ContractTestRunner(baseObj, parentTestInfo, testInfo, excludeMethods));
        }
        if (runners.size() == 0) {
            LOG.info((Object)("No tests for " + testClass));
        }
    }

    protected List<Runner> getChildren() {
        return this.fRunners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        LOG.debug((Object)String.format("Running: %s ", child));
        child.run(notifier);
    }

    private class BaseClassRunner
    extends BlockJUnit4ClassRunner {
        private List<FrameworkMethod> testMethods;

        public BaseClassRunner(Class<?> cls) throws InitializationError {
            super(cls);
            this.testMethods = null;
        }

        protected Statement withAfterClasses(Statement statement) {
            return statement;
        }

        protected Statement withBeforeClasses(Statement statement) {
            return statement;
        }

        protected void validateInstanceMethods(List<Throwable> errors) {
            this.validatePublicVoidNoArgMethods(After.class, false, errors);
            this.validatePublicVoidNoArgMethods(Before.class, false, errors);
            this.validateTestMethods(errors);
        }

        protected List<FrameworkMethod> computeTestMethods() {
            if (this.testMethods == null) {
                this.testMethods = new ArrayList<FrameworkMethod>();
                List excludeMethods = ContractSuite.this.getExcludedMethods(this.getTestClass().getJavaClass());
                for (FrameworkMethod mthd : super.getTestClass().getAnnotatedMethods(ContractTest.class)) {
                    if (mthd.getMethod().getDeclaringClass().getAnnotation(Contract.class) != null || excludeMethods.contains(mthd.getMethod())) continue;
                    this.testMethods.add(mthd);
                }
            }
            return this.testMethods;
        }
    }
}

