/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.xenei.junit.contract.ContractTest;
import org.xenei.junit.contract.info.DynamicTestInfo;
import org.xenei.junit.contract.info.TestInfo;

public class ContractTestRunner
extends BlockJUnit4ClassRunner {
    private final TestInfo parentTestInfo;
    private final TestInfo testInfo;
    private final Object getterObj;
    private final Method getter;
    private final List<Method> excludedMethods;

    public ContractTestRunner(Object getterObj, TestInfo parentTestInfo, TestInfo testInfo, List<Method> excludedMethods) throws InitializationError {
        super(testInfo.getContractTestClass());
        this.parentTestInfo = parentTestInfo;
        this.testInfo = testInfo;
        this.getterObj = getterObj;
        this.getter = parentTestInfo.getMethod();
        this.excludedMethods = excludedMethods;
    }

    public ContractTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.parentTestInfo = null;
        this.testInfo = null;
        this.getterObj = null;
        this.getter = null;
        this.excludedMethods = Collections.emptyList();
    }

    protected Object createTest() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object retval = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        if (this.parentTestInfo != null) {
            if (this.parentTestInfo instanceof DynamicTestInfo) {
                DynamicTestInfo dti = (DynamicTestInfo)this.parentTestInfo;
                Object baseProducer = dti.getDynamicInjector().invoke(this.getterObj, new Object[0]);
                this.testInfo.getMethod().invoke(retval, dti.getProducer(baseProducer));
            } else {
                this.testInfo.getMethod().invoke(retval, this.getter.invoke(this.getterObj, new Object[0]));
            }
        }
        return retval;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null || this.excludedMethods.contains(method.getMethod())) {
            notifier.fireTestIgnored(description);
        } else {
            this.runLeaf(this.methodBlock(method), description, notifier);
        }
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected String getName() {
        return this.testInfo == null ? super.getName() : this.testInfo.getContractTestClass().getName();
    }

    protected Description describeChild(FrameworkMethod method) {
        if (this.testInfo == null) {
            return super.describeChild(method);
        }
        if (this.parentTestInfo == null) {
            return Description.createTestDescription(this.testInfo.getContractTestClass(), (String)this.testName(method), (Annotation[])method.getAnnotations());
        }
        String name = String.format("%s(%s)", this.testName(method), this.testInfo.getContractTestClass().getSimpleName());
        return Description.createTestDescription(this.parentTestInfo.getContractTestClass(), (String)name, (Annotation[])method.getAnnotations());
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(ContractTest.class);
    }

    public String toString() {
        return "ContractTest" + this.testInfo == null ? "" : this.testInfo.toString();
    }
}

