/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.info;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.AndClassFilter;
import org.xenei.classpathutils.filter.NameClassFilter;
import org.xenei.classpathutils.filter.NotClassFilter;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.info.TestInfo;

public class ContractTestMap {
    private final Map<Class<?>, TestInfo> classToInfoMap = new HashMap();
    private final Map<Class<?>, Set<TestInfo>> interfaceToInfoMap = new HashMap();
    private final ClassPathFilter skipFilter;
    private static final Log LOG = LogFactory.getLog(ContractTestMap.class);

    public ContractTestMap() {
        this(ClassPathFilter.FALSE);
    }

    public ContractTestMap(ClassPathFilter ignoreFilter) {
        String prop = System.getProperty("contracts.skipClasses");
        if (prop != null) {
            NameClassFilter cf = null;
            ArrayList<String> names = new ArrayList<String>();
            for (String iFace : prop.split(",")) {
                names.add(iFace.trim());
            }
            cf = new NameClassFilter(names);
            this.skipFilter = new AndClassFilter(new NotClassFilter(cf), new NotClassFilter(ignoreFilter)).optimize();
        } else {
            this.skipFilter = new NotClassFilter(ignoreFilter).optimize();
        }
        FastClasspathScanner scanner = new FastClasspathScanner(new String[0]);
        ClassAnnotationMatchProcessor mp = new ClassAnnotationMatchProcessor(){

            @Override
            public void processMatch(Class<?> matchingClass) {
                if (ContractTestMap.this.skipFilter.accept(matchingClass)) {
                    Contract c = matchingClass.getAnnotation(Contract.class);
                    LOG.debug((Object)String.format("adding %s %s", matchingClass, c));
                    ContractTestMap.this.add(new TestInfo(matchingClass, c));
                }
            }
        };
        scanner.matchClassesWithAnnotation(Contract.class, mp);
        scanner.scan();
    }

    public void add(TestInfo info) {
        this.classToInfoMap.put(info.getContractTestClass(), info);
        Set<TestInfo> tiSet = this.interfaceToInfoMap.get(info.getClassUnderTest());
        if (tiSet == null) {
            tiSet = new HashSet<TestInfo>();
            this.interfaceToInfoMap.put(info.getClassUnderTest(), tiSet);
        }
        tiSet.add(info);
    }

    public TestInfo getInfoByTestClass(Class<?> testClass) {
        return this.classToInfoMap.get(testClass);
    }

    public Set<TestInfo> getInfoByInterfaceClass(Class<?> contract) {
        Set<TestInfo> ti = this.interfaceToInfoMap.get(contract);
        if (ti == null) {
            LOG.debug((Object)String.format("Found no tests for interface %s.", contract));
            return Collections.emptySet();
        }
        return this.interfaceToInfoMap.get(contract);
    }

    public Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet result = new HashSet();
        this.getAllInterfaces(result, clazz);
        return result;
    }

    private void getAllInterfaces(Set<Class<?>> set, Class<?> ... clazz) {
        if (clazz != null) {
            for (Class<?> c : clazz) {
                if (c == null) continue;
                if (c.isInterface() && !set.contains(c)) {
                    set.add(c);
                }
                this.getAllInterfaces(set, c.getInterfaces());
                this.getAllInterfaces(set, c.getSuperclass());
            }
        }
    }

    public Set<TestInfo> getAnnotatedClasses(Set<TestInfo> testClasses, TestInfo contractClassInfo) {
        Set<Class<?>> lst = this.getAllInterfaces(contractClassInfo.getClassUnderTest());
        for (Class clazz : lst) {
            testClasses.addAll(this.getInfoByInterfaceClass(clazz));
        }
        return testClasses;
    }

    public Collection<TestInfo> listTestInfo() {
        return this.classToInfoMap.values();
    }
}

