/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.tooling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.ClassPathUtils;
import org.xenei.classpathutils.filter.AndClassFilter;
import org.xenei.classpathutils.filter.HasAnnotationClassFilter;
import org.xenei.classpathutils.filter.NotClassFilter;
import org.xenei.classpathutils.filter.OrClassFilter;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.NoContractTest;
import org.xenei.junit.contract.info.ContractTestMap;
import org.xenei.junit.contract.info.TestInfo;
import org.xenei.junit.contract.tooling.InterfaceInfo;

public class InterfaceReport {
    private final Collection<Class<?>> packageClasses;
    private final ClassPathFilter filter;
    private Map<Class<?>, InterfaceInfo> interfaceInfoMap;
    private final ContractTestMap contractTestMap;
    private final ContractImplMap contractImplMap;
    private static final Log LOG = LogFactory.getLog(ContractTestMap.class);
    private static final ClassPathFilter INTERESTING_CLASSES = new AndClassFilter(ClassPathFilter.INTERFACE_CLASS, new NotClassFilter(ClassPathFilter.ANNOTATION_CLASS), new NotClassFilter(new HasAnnotationClassFilter(NoContractTest.class)));
    private static final Comparator<Class<?>> CLASS_NAME_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public Collection<InterfaceInfo> getInterfaceInfoCollection() {
        return this.getInterfaceInfoMap().values();
    }

    private Map<Class<?>, InterfaceInfo> getInterfaceInfoMap() {
        if (this.interfaceInfoMap == null) {
            this.interfaceInfoMap = new HashMap();
            for (Class<?> c : this.packageClasses) {
                if (INTERESTING_CLASSES.accept(c)) {
                    if (this.interfaceInfoMap.containsKey(c)) continue;
                    this.interfaceInfoMap.put(c, new InterfaceInfo(c));
                    continue;
                }
                Contract contract = c.getAnnotation(Contract.class);
                if (contract == null) continue;
                InterfaceInfo ii = this.interfaceInfoMap.get(contract.value());
                if (ii == null) {
                    ii = new InterfaceInfo(contract.value());
                    this.interfaceInfoMap.put(contract.value(), ii);
                }
                ii.add(c);
            }
        }
        return this.interfaceInfoMap;
    }

    public InterfaceReport(String[] packages, ClassPathFilter filter, ClassLoader classLoader) {
        if (packages.length == 0) {
            throw new IllegalArgumentException("At least one package must be specified");
        }
        this.contractTestMap = new ContractTestMap();
        this.filter = filter != null ? filter : ClassPathFilter.TRUE;
        this.packageClasses = new HashSet();
        for (String p : packages) {
            this.packageClasses.addAll(ClassPathUtils.getClasses(classLoader, p, this.filter));
        }
        if (this.packageClasses.size() == 0) {
            throw new IllegalArgumentException("No classes found in " + Arrays.asList(packages));
        }
        this.contractImplMap = new ContractImplMap(this.packageClasses);
    }

    public Collection<Class<?>> getPackageClasses() {
        return this.packageClasses;
    }

    public List<Throwable> getErrors() {
        ArrayList<Throwable> retval = new ArrayList<Throwable>();
        for (TestInfo testInfo : this.contractTestMap.listTestInfo()) {
            retval.addAll(testInfo.getErrors());
        }
        return retval;
    }

    public Set<Class<?>> getUntestedInterfaces() {
        TreeSet retval = new TreeSet(CLASS_NAME_COMPARATOR);
        for (InterfaceInfo info : this.getInterfaceInfoMap().values()) {
            if (!info.getTests().isEmpty() || info.getName().getDeclaredMethods().length <= 0) continue;
            retval.add(info.getName());
        }
        return retval;
    }

    public Set<Class<?>> getUnImplementedTests() {
        TreeSet retval = new TreeSet(CLASS_NAME_COMPARATOR);
        NotClassFilter filter = new NotClassFilter(new OrClassFilter(ClassPathFilter.ABSTRACT_CLASS, ClassPathFilter.INTERFACE_CLASS));
        for (Class<?> clazz : filter.filterClasses(this.packageClasses)) {
            LOG.debug((Object)String.format("checking %s for contract tests", clazz));
            Set<Class<Class<?>>> interfaces = this.contractTestMap.getAllInterfaces(clazz);
            if (!interfaces.isEmpty()) {
                Map<Class<?>, InterfaceInfo> interfaceInfo = this.getInterfaceInfoMap();
                interfaces.retainAll(interfaceInfo.keySet());
            }
            if (interfaces.isEmpty() || this.contractImplMap.hasTestFor(clazz)) continue;
            retval.add(clazz);
        }
        return retval;
    }

    public ClassPathFilter getClassFilter() {
        return this.filter;
    }

    private static class ContractImplMap {
        private final Map<Class<?>, Set<Class<?>>> forwardMap = new HashMap();
        private final Map<Class<?>, Class<?>> reverseMap = new HashMap();

        public ContractImplMap(Collection<Class<?>> classes) {
            for (Class<?> c : classes) {
                ContractImpl contractImpl = c.getAnnotation(ContractImpl.class);
                if (contractImpl == null) continue;
                this.add(c, contractImpl);
            }
        }

        private void add(Class<?> contractTestImplClass, ContractImpl contractImpl) {
            Set<Class<?>> set = this.forwardMap.get(contractImpl.value());
            if (set == null) {
                set = new HashSet();
                this.forwardMap.put(contractImpl.value(), set);
            }
            set.add(contractTestImplClass);
            this.reverseMap.put(contractTestImplClass, contractImpl.value());
        }

        public boolean hasTestFor(Class<?> contractTestImplClass) {
            return this.forwardMap.containsKey(contractTestImplClass);
        }
    }
}

