/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.mmap;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import xerial.larray.buffer.LBufferAPI;
import xerial.larray.buffer.LBufferConfig;
import xerial.larray.buffer.UnsafeUtil;
import xerial.larray.impl.LArrayNative;
import xerial.larray.impl.OSInfo;
import xerial.larray.mmap.MMapMemory;
import xerial.larray.mmap.MMapMode;

public class MMapBuffer
extends LBufferAPI {
    private final RandomAccessFile raf;
    private final FileChannel fc;
    private final long fd;
    private final int pagePosition;
    private final long address;
    private long winHandle = -1L;

    public long address() {
        return this.address;
    }

    public MMapBuffer(File file, MMapMode mMapMode) throws IOException {
        this(file, 0L, file.length(), mMapMode);
    }

    public MMapBuffer(File file, long l, long l2, MMapMode mMapMode) throws IOException {
        this.raf = new RandomAccessFile(file, mMapMode.mode);
        this.fc = this.raf.getChannel();
        FileDescriptor fileDescriptor = this.raf.getFD();
        try {
            Field field;
            if (!OSInfo.isWindows()) {
                field = fileDescriptor.getClass().getDeclaredField("fd");
                field.setAccessible(true);
                this.fd = field.getInt(fileDescriptor);
            } else {
                field = fileDescriptor.getClass().getDeclaredField("handle");
                field.setAccessible(true);
                this.fd = field.getLong(fileDescriptor);
            }
        }
        catch (Exception exception) {
            throw new IOException("Failed to retrieve file descriptor of " + file.getPath() + ": " + exception.getMessage());
        }
        long l3 = UnsafeUtil.unsafe.pageSize();
        this.pagePosition = (int)(l % l3);
        if (!this.fc.isOpen()) {
            throw new IOException("closed " + file.getPath());
        }
        long l4 = this.fc.size();
        if (l4 < l + l2) {
            this.raf.seek(l + l2 - 1L);
            this.raf.write(0);
        }
        long l5 = l - (long)this.pagePosition;
        long l6 = l2 + (long)this.pagePosition;
        long l7 = LArrayNative.mmap(this.fd, mMapMode.code, l5, l6);
        if (OSInfo.isWindows()) {
            JavaIOFileDescriptorAccess javaIOFileDescriptorAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
            this.winHandle = LArrayNative.duplicateHandle(javaIOFileDescriptorAccess.getHandle(this.raf.getFD()));
        }
        this.m = new MMapMemory(l7, l6);
        LBufferConfig.allocator.register(this.m);
        this.address = l7 + (long)this.pagePosition;
    }

    public void flush() {
        LArrayNative.msync(this.winHandle, this.m.headerAddress(), this.m.size());
    }

    public void close() throws IOException {
        this.release();
        this.fc.close();
    }
}

