/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray;

import java.nio.ByteBuffer;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import sun.nio.ch.DirectBuffer;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;
import xerial.larray.LArray;
import xerial.larray.LArray$;
import xerial.larray.LArrayBuilder$;
import xerial.larray.LBuilder;
import xerial.larray.LBuilder$class;
import xerial.larray.LByteArray;
import xerial.larray.LIterator;
import xerial.larray.LSeq;
import xerial.larray.UnsafeUtil$;
import xerial.larray.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0001\u0003\u0003\u00039!!\u0004'BeJ\f\u0017PQ;jY\u0012,'O\u0003\u0002\u0004\t\u00051A.\u0019:sCfT\u0011!B\u0001\u0007q\u0016\u0014\u0018.\u00197\u0004\u0001U\u0019\u0001b\u0006\u0013\u0014\t\u0001I\u0011C\u000b\t\u0003\u0015=i\u0011a\u0003\u0006\u0003\u00195\tA\u0001\\1oO*\ta\"\u0001\u0003kCZ\f\u0017B\u0001\t\f\u0005\u0019y%M[3diB!!cE\u000b$\u001b\u0005\u0011\u0011B\u0001\u000b\u0003\u0005!a%)^5mI\u0016\u0014\bC\u0001\f\u0018\u0019\u0001!Q\u0001\u0007\u0001C\u0002e\u0011\u0011!Q\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0004\u0003:L\bC\u0001\f%\t\u0015)\u0003A1\u0001'\u0005\u0011\u0011V\r\u001d:\u0012\u0005i9\u0003c\u0001\n)+%\u0011\u0011F\u0001\u0002\u0007\u0019\u0006\u0013(/Y=\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013a\u00017pO*\tq&A\u0003xm2,G/\u0003\u00022Y\tQAj\\4TkB\u0004xN\u001d;\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\u0005)\u0004\u0003\u0002\n\u0001+\rB\u0011b\u000e\u0001A\u0002\u0003\u0007I\u0011\u0003\u001d\u0002\u000b\u0015dW-\\:\u0016\u0003e\u0002\"A\u0005\u001e\n\u0005m\u0012!A\u0003'CsR,\u0017I\u001d:bs\"IQ\b\u0001a\u0001\u0002\u0004%\tBP\u0001\nK2,Wn]0%KF$\"a\u0010\"\u0011\u0005m\u0001\u0015BA!\u001d\u0005\u0011)f.\u001b;\t\u000f\rc\u0014\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0003\u0001\u0015)\u0003:\u0003\u0019)G.Z7tA!9q\t\u0001a\u0001\n#A\u0015\u0001C2ba\u0006\u001c\u0017\u000e^=\u0016\u0003%\u0003\"a\u0007&\n\u0005-c\"\u0001\u0002'p]\u001eDq!\u0014\u0001A\u0002\u0013Ea*\u0001\u0007dCB\f7-\u001b;z?\u0012*\u0017\u000f\u0006\u0002@\u001f\"91\tTA\u0001\u0002\u0004I\u0005BB)\u0001A\u0003&\u0011*A\u0005dCB\f7-\u001b;zA!91\u000b\u0001a\u0001\n#A\u0015AB2veN|'\u000fC\u0004V\u0001\u0001\u0007I\u0011\u0003,\u0002\u0015\r,(o]8s?\u0012*\u0017\u000f\u0006\u0002@/\"91\tVA\u0001\u0002\u0004I\u0005BB-\u0001A\u0003&\u0011*A\u0004dkJ\u001cxN\u001d\u0011\t\u000bm\u0003A\u0011\u0003%\u0002\u00119,X.\u00127f[NDQ!\u0018\u0001\u0005\u0002y\u000ba!\u00199qK:$G\u0003B\u001b`O2DQ\u0001\u0019/A\u0002\u0005\f\u0011A\u0019\t\u00047\t$\u0017BA2\u001d\u0005\u0015\t%O]1z!\tYR-\u0003\u0002g9\t!!)\u001f;f\u0011\u0015AG\f1\u0001j\u0003\u0019ygMZ:fiB\u00111D[\u0005\u0003Wr\u00111!\u00138u\u0011\u0015iG\f1\u0001j\u0003\raWM\u001c\u0005\u0006;\u0002!\ta\u001c\u000b\u0003aFl\u0011\u0001\u0001\u0005\u0006e:\u0004\ra]\u0001\u0004g\u0016\f\bc\u0001\nu+%\u0011QO\u0001\u0002\u0005\u0019N+\u0017\u000fC\u0003x\u0001\u0011E\u00010A\u0004nW\u0006\u0013(/Y=\u0015\u0005eJ\b\"\u0002>w\u0001\u0004I\u0015\u0001B:ju\u0016DQ\u0001 \u0001\u0005\u0002u\f\u0001b]5{K\"Kg\u000e\u001e\u000b\u0003\u007fyDQA_>A\u0002%Cq!!\u0001\u0001\t#\t\u0019!\u0001\u0006f]N,(/Z*ju\u0016$2aPA\u0003\u0011\u0015Qx\u00101\u0001J\u0011\u001d\tI\u0001\u0001C\t\u0003\u0017\taA]3tSj,GcA \u0002\u000e!1!0a\u0002A\u0002%Cq!!\u0005\u0001\t\u0003\t\u0019\"A\u0003dY\u0016\f'\u000fF\u0001@\u0011\u001d\t9\u0002\u0001C\u0001\u00033\tQa\u001e:ji\u0016$2![A\u000e\u0011!\ti\"!\u0006A\u0002\u0005}\u0011aA:sGB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&5\t1A\\5p\u0013\u0011\tI#a\t\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0002.\u0001!\t!a\f\u0002\r%\u001cx\n]3o)\t\t\t\u0004E\u0002\u001c\u0003gI1!!\u000e\u001d\u0005\u001d\u0011un\u001c7fC:Dq!!\u000f\u0001\t\u0003\t\u0019\"A\u0003dY>\u001cXmB\u0004\u0002>\tA\t!a\u0010\u0002\u001b1\u000b%O]1z\u0005VLG\u000eZ3s!\r\u0011\u0012\u0011\t\u0004\u0007\u0003\tA\t!a\u0011\u0014\r\u0005\u0005\u0013QIA&!\rY\u0012qI\u0005\u0004\u0003\u0013b\"AB!osJ+g\rE\u0002\u001c\u0003\u001bJ1!a\u0014\u001d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d\u0019\u0014\u0011\tC\u0001\u0003'\"\"!a\u0010\t\u0011\u0005]\u0013\u0011\tC\u0001\u00033\nA!\\1lKV!\u00111LA2)\t\ti\u0006\u0006\u0003\u0002`\u0005%\u0004C\u0002\n\u0014\u0003C\n9\u0007E\u0002\u0017\u0003G\"q!!\u001a\u0002V\t\u0007\u0011DA\u0001U!\u0011\u0011\u0002&!\u0019\t\u0015\u0005-\u0014QKA\u0001\u0002\b\ti'\u0001\u0006fm&$WM\\2fII\u0002b!a\u001c\u0002v\u0005\u0005TBAA9\u0015\r\t\u0019\bH\u0001\be\u00164G.Z2u\u0013\u0011\t9(!\u001d\u0003\u0011\rc\u0017m]:UC\u001eD!\"a\u001f\u0002B\u0005\u0005I\u0011BA?\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003%\u0001")
public abstract class LArrayBuilder<A, Repr extends LArray<A>>
implements LBuilder<A, Repr>,
LogSupport {
    private LByteArray elems;
    private long capacity;
    private long cursor;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <T> LBuilder<T, LArray<T>> make(ClassTag<T> classTag) {
        return LArrayBuilder$.MODULE$.make(classTag);
    }

    private Logger logger$lzycompute() {
        LArrayBuilder lArrayBuilder = this;
        synchronized (lArrayBuilder) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogger.class.logger((LazyLogger)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public LBuilder<A, Repr> append(A elem) {
        return LBuilder$class.append(this, elem);
    }

    @Override
    public LBuilder<A, Repr> $plus$plus$eq(TraversableOnce<A> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    @Override
    public LBuilder<A, Repr> $plus$plus$eq(LIterator<A> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    public LByteArray elems() {
        return this.elems;
    }

    public void elems_$eq(LByteArray x$1) {
        this.elems = x$1;
    }

    public long capacity() {
        return this.capacity;
    }

    public void capacity_$eq(long x$1) {
        this.capacity = x$1;
    }

    public long cursor() {
        return this.cursor;
    }

    public void cursor_$eq(long x$1) {
        this.cursor = x$1;
    }

    public long numElems() {
        return this.cursor() / this.elementSize();
    }

    public LArrayBuilder<A, Repr> append(byte[] b, int offset, int len) {
        long elemsToAdd = ((long)len + this.elementSize() - 1L) / this.elementSize();
        this.ensureSize(this.numElems() + elemsToAdd);
        this.elems().readFromArray(b, offset, this.cursor(), len);
        this.cursor_$eq(this.cursor() + (long)len);
        return this;
    }

    @Override
    public LArrayBuilder<A, Repr> append(LSeq<A> seq) {
        long n = seq.size();
        this.ensureSize(this.numElems() + n);
        seq.copyTo(this.elems(), this.cursor());
        this.cursor_$eq(this.cursor() + n * this.elementSize());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LByteArray mkArray(long size2) {
        void var3_2;
        LByteArray newArray = new LByteArray(size2 * this.elementSize(), package$.MODULE$.defaultAllocator());
        if (this.numElems() > 0L) {
            LArray$.MODULE$.copy(this.elems(), newArray);
            this.elems().free();
        }
        return var3_2;
    }

    @Override
    public void sizeHint(long size2) {
        if (this.capacity() < size2) {
            this.resize(size2);
        }
    }

    public void ensureSize(long size2) {
        long factor = 2L;
        if (this.capacity() < size2 || this.capacity() == 0L) {
            long newsize;
            long l = newsize = this.capacity() <= 1L ? 16L : this.capacity() * factor;
            while (newsize < size2) {
                newsize *= factor;
            }
            this.resize(newsize);
        }
    }

    public void resize(long size2) {
        this.elems_$eq(this.mkArray(size2));
        this.capacity_$eq(size2);
    }

    @Override
    public void clear() {
        if (this.numElems() > 0L) {
            this.elems().free();
        }
        this.capacity_$eq(0L);
        this.cursor_$eq(0L);
    }

    @Override
    public int write(ByteBuffer src) {
        int n;
        int len = scala.math.package$.MODULE$.max(src.limit() - src.position(), 0);
        long toAdd = ((long)len + this.elementSize() - 1L) / this.elementSize();
        this.ensureSize(this.numElems() + toAdd);
        ByteBuffer byteBuffer = src;
        if (byteBuffer instanceof DirectBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            UnsafeUtil$.MODULE$.unsafe().copyMemory(((DirectBuffer)((Object)byteBuffer2)).address() + (long)byteBuffer2.position(), this.elems().address() + this.cursor(), len);
            n = len;
        } else if (src.hasArray()) {
            n = this.elems().readFromArray(src.array(), src.position(), this.cursor(), len);
        } else {
            long c = this.cursor();
            for (long i = 0L; i < (long)len; ++i) {
                this.elems().putByte(c + i, src.get((int)((long)src.position() + i)));
            }
            n = len;
        }
        int writeLen = n;
        this.cursor_$eq(this.cursor() + (long)writeLen);
        src.position(src.position() + writeLen);
        return writeLen;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
        this.clear();
    }

    public LArrayBuilder() {
        LBuilder$class.$init$(this);
        LoggingMethods.class.$init$((LoggingMethods)this);
        LazyLogger.class.$init$((LazyLogger)this);
        this.capacity = 0L;
        this.cursor = 0L;
    }
}

