/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray;

import java.nio.ByteBuffer;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;
import xerial.larray.BitEncoder$;
import xerial.larray.LArray$;
import xerial.larray.LBitArray;
import xerial.larray.LBuilder;
import xerial.larray.LBuilder$class;
import xerial.larray.LIterator;
import xerial.larray.LLongArray;
import xerial.larray.LSeq;
import xerial.larray.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003\u0014\"ji\u0006\u0013(/Y=Ck&dG-\u001a:\u000b\u0005\r!\u0011A\u00027beJ\f\u0017PC\u0001\u0006\u0003\u0019AXM]5bY\u000e\u00011\u0003\u0002\u0001\t!u\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0005#I!\"$D\u0001\u0003\u0013\t\u0019\"A\u0001\u0005M\u0005VLG\u000eZ3s!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u001d\u0011un\u001c7fC:\u0004\"!E\u000e\n\u0005q\u0011!!\u0003'CSR\f%O]1z!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0002m_\u001eT\u0011AI\u0001\u0006oZdW\r^\u0005\u0003I}\u0011!\u0002T8h'V\u0004\bo\u001c:u\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002\u0012\u0001!)!\u0006\u0001C\u0001W\u0005YQ\r\\3nK:$8+\u001b>f+\u0005a\u0003CA\u000b.\u0013\tqcCA\u0004O_RD\u0017N\\4\t\u0013A\u0002\u0001\u0019!a\u0001\n\u0013\t\u0014!B3mK6\u001cX#\u0001\u001a\u0011\u0005E\u0019\u0014B\u0001\u001b\u0003\u0005)aEj\u001c8h\u0003J\u0014\u0018-\u001f\u0005\nm\u0001\u0001\r\u00111A\u0005\n]\n\u0011\"\u001a7f[N|F%Z9\u0015\u0005aZ\u0004CA\u000b:\u0013\tQdC\u0001\u0003V]&$\bb\u0002\u001f6\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\n\u0004B\u0002 \u0001A\u0003&!'\u0001\u0004fY\u0016l7\u000f\t\u0005\b\u0001\u0002\u0001\r\u0011\"\u0003B\u0003!\u0019\u0017\r]1dSRLX#\u0001\"\u0011\u0005U\u0019\u0015B\u0001#\u0017\u0005\u0011auN\\4\t\u000f\u0019\u0003\u0001\u0019!C\u0005\u000f\u0006a1-\u00199bG&$\u0018p\u0018\u0013fcR\u0011\u0001\b\u0013\u0005\by\u0015\u000b\t\u00111\u0001C\u0011\u0019Q\u0005\u0001)Q\u0005\u0005\u0006I1-\u00199bG&$\u0018\u0010\t\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003B\u0003\u001dqW/\u001c\"jiNDqA\u0014\u0001A\u0002\u0013%q*A\u0006ok6\u0014\u0015\u000e^:`I\u0015\fHC\u0001\u001dQ\u0011\u001daT*!AA\u0002\tCaA\u0015\u0001!B\u0013\u0011\u0015\u0001\u00038v[\nKGo\u001d\u0011\t\u000bQ\u0003A\u0011C+\u0002\u000f5\\\u0017I\u001d:bsR\u0011!G\u0016\u0005\u0006/N\u0003\rAQ\u0001\u0005g&TX\rC\u0003Z\u0001\u0011\u0005!,\u0001\u0005tSj,\u0007*\u001b8u)\tA4\fC\u0003X1\u0002\u0007!\tC\u0003^\u0001\u0011Ea,\u0001\u0006f]N,(/Z*ju\u0016$\"\u0001O0\t\u000b]c\u0006\u0019\u0001\"\t\u000b\u0005\u0004A\u0011\u00032\u0002\rI,7/\u001b>f)\tA4\rC\u0003XA\u0002\u0007!\tC\u0003f\u0001\u0011\u0005a-A\u0003dY\u0016\f'\u000fF\u00019\u0011\u0015A\u0007\u0001\"\u0011j\u0003!!\u0003\u000f\\;tI\u0015\fHC\u00016l\u001b\u0005\u0001\u0001\"\u00027h\u0001\u0004!\u0012!\u0001<\t\u000b9\u0004A\u0011A8\u0002\rI,7/\u001e7u)\u0005Q\u0002\"\u00028\u0001\t\u0003\tHC\u0001\u000es\u0011\u0015a\u0005\u000f1\u0001C\u0011\u0015!\b\u0001\"\u0011v\u0003!!xn\u0015;sS:<G#\u0001<\u0011\u0005]ThBA\u000by\u0013\tIh#\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u0014aa\u0015;sS:<'BA=\u0017\u0011\u0015q\b\u0001\"\u0001\u0000\u0003\u0019\t\u0007\u000f]3oIR\u0019!.!\u0001\t\u000f\u0005\rQ\u00101\u0001\u0002\u0006\u0005\u00191/Z9\u0011\tE\t9\u0001F\u0005\u0004\u0003\u0013\u0011!\u0001\u0002'TKFDq!!\u0004\u0001\t\u0003\ty!A\u0003xe&$X\rF\u0002-\u0003#A\u0001\"a\u0005\u0002\f\u0001\u0007\u0011QC\u0001\u0004gJ\u001c\u0007\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mA\"A\u0002oS>LA!a\b\u0002\u001a\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u00051\u0011n](qK:$\u0012\u0001\u0006\u0005\u0007\u0003S\u0001A\u0011\u00014\u0002\u000b\rdwn]3")
public class LBitArrayBuilder
implements LBuilder<Object, LBitArray>,
LogSupport {
    private LLongArray elems;
    private long capacity;
    private long numBits;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        LBitArrayBuilder lBitArrayBuilder = this;
        synchronized (lBitArrayBuilder) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogger.class.logger((LazyLogger)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public LBuilder append(Object elem) {
        return LBuilder$class.append(this, elem);
    }

    @Override
    public LBuilder<Object, LBitArray> $plus$plus$eq(TraversableOnce<Object> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    @Override
    public LBuilder<Object, LBitArray> $plus$plus$eq(LIterator<Object> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    public Nothing$ elementSize() {
        throw new UnsupportedOperationException("elementSize of LBitArrayBuilder");
    }

    private LLongArray elems() {
        return this.elems;
    }

    private void elems_$eq(LLongArray x$1) {
        this.elems = x$1;
    }

    private long capacity() {
        return this.capacity;
    }

    private void capacity_$eq(long x$1) {
        this.capacity = x$1;
    }

    private long numBits() {
        return this.numBits;
    }

    private void numBits_$eq(long x$1) {
        this.numBits = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LLongArray mkArray(long size2) {
        void var3_2;
        LLongArray newArray = new LLongArray(BitEncoder$.MODULE$.minArraySize(size2), package$.MODULE$.defaultAllocator());
        newArray.clear();
        if (this.capacity() > 0L) {
            LArray$.MODULE$.copy(this.elems(), newArray);
            this.elems().free();
        }
        return var3_2;
    }

    @Override
    public void sizeHint(long size2) {
        if (this.capacity() < size2) {
            this.resize(size2);
        }
    }

    public void ensureSize(long size2) {
        long factor = 2L;
        if (this.capacity() < size2 || this.capacity() == 0L) {
            long newsize;
            long l = newsize = this.capacity() <= 1L ? 64L : this.capacity() * factor;
            while (newsize < size2) {
                newsize *= factor;
            }
            this.resize(newsize);
        }
    }

    public void resize(long size2) {
        this.elems_$eq(this.mkArray(size2));
        this.capacity_$eq(size2);
    }

    @Override
    public void clear() {
        if (this.numBits() > 0L) {
            this.elems().free();
        }
        this.capacity_$eq(0L);
        this.numBits_$eq(0L);
    }

    public LBitArrayBuilder $plus$eq(boolean v) {
        long l;
        this.ensureSize(this.numBits() + 1L);
        long pos = BitEncoder$.MODULE$.blockIndex(this.numBits());
        int offset = BitEncoder$.MODULE$.blockOffset(this.numBits());
        if (v) {
            LLongArray lLongArray = this.elems();
            l = lLongArray.update(pos, lLongArray.apply(pos) | 1L << offset);
        } else {
            LLongArray lLongArray = this.elems();
            l = lLongArray.update(pos, lLongArray.apply(pos) & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.numBits_$eq(this.numBits() + 1L);
        return this;
    }

    @Override
    public LBitArray result() {
        long s = BitEncoder$.MODULE$.minArraySize(this.numBits());
        return this.capacity() != 0L && this.capacity() == s ? new LBitArray(this.elems(), this.numBits()) : new LBitArray(this.mkArray(this.numBits()), this.numBits());
    }

    public LBitArray result(long numBits) {
        this.numBits_$eq(numBits);
        return this.result();
    }

    public String toString() {
        return this.result().toString();
    }

    public LBitArrayBuilder append(LSeq<Object> seq) {
        long N = seq.length();
        this.ensureSize(this.numBits() + N);
        for (long i = 0L; i < N; ++i) {
            this.$plus$eq(BoxesRunTime.unboxToBoolean((Object)seq.apply(i)));
        }
        this.numBits_$eq(this.numBits() + N);
        return this;
    }

    public Nothing$ write(ByteBuffer src) {
        throw new UnsupportedOperationException("write(ByteBuffer)");
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    public LBitArrayBuilder() {
        LBuilder$class.$init$(this);
        LoggingMethods.class.$init$((LoggingMethods)this);
        LazyLogger.class.$init$((LazyLogger)this);
        this.capacity = 0L;
        this.numBits = 0L;
    }
}

