/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.sheet.FontFaceRule;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.TrueTypeUtil;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class ITextFontResolver
implements FontResolver {
    private final Map<String, FontFamily> _fontFamilies = ITextFontResolver.createInitialFontMap();
    private final Map<String, FontDescription> _fontCache = new HashMap<String, FontDescription>();
    private final UserAgentCallback userAgent;
    private static final String[][] cjkFonts = new String[][]{{"STSong-Light-H", "STSong-Light", "UniGB-UCS2-H"}, {"STSong-Light-V", "STSong-Light", "UniGB-UCS2-V"}, {"STSongStd-Light-H", "STSongStd-Light", "UniGB-UCS2-H"}, {"STSongStd-Light-V", "STSongStd-Light", "UniGB-UCS2-V"}, {"MHei-Medium-H", "MHei-Medium", "UniCNS-UCS2-H"}, {"MHei-Medium-V", "MHei-Medium", "UniCNS-UCS2-V"}, {"MSung-Light-H", "MSung-Light", "UniCNS-UCS2-H"}, {"MSung-Light-V", "MSung-Light", "UniCNS-UCS2-V"}, {"MSungStd-Light-H", "MSungStd-Light", "UniCNS-UCS2-H"}, {"MSungStd-Light-V", "MSungStd-Light", "UniCNS-UCS2-V"}, {"HeiseiMin-W3-H", "HeiseiMin-W3", "UniJIS-UCS2-H"}, {"HeiseiMin-W3-V", "HeiseiMin-W3", "UniJIS-UCS2-V"}, {"HeiseiKakuGo-W5-H", "HeiseiKakuGo-W5", "UniJIS-UCS2-H"}, {"HeiseiKakuGo-W5-V", "HeiseiKakuGo-W5", "UniJIS-UCS2-V"}, {"KozMinPro-Regular-H", "KozMinPro-Regular", "UniJIS-UCS2-HW-H"}, {"KozMinPro-Regular-V", "KozMinPro-Regular", "UniJIS-UCS2-HW-V"}, {"HYGoThic-Medium-H", "HYGoThic-Medium", "UniKS-UCS2-H"}, {"HYGoThic-Medium-V", "HYGoThic-Medium", "UniKS-UCS2-V"}, {"HYSMyeongJo-Medium-H", "HYSMyeongJo-Medium", "UniKS-UCS2-H"}, {"HYSMyeongJo-Medium-V", "HYSMyeongJo-Medium", "UniKS-UCS2-V"}, {"HYSMyeongJoStd-Medium-H", "HYSMyeongJoStd-Medium", "UniKS-UCS2-H"}, {"HYSMyeongJoStd-Medium-V", "HYSMyeongJoStd-Medium", "UniKS-UCS2-V"}};

    public ITextFontResolver(UserAgentCallback userAgent) {
        this.userAgent = userAgent;
    }

    public static Set<String> getDistinctFontFamilyNames(String path, String encoding, boolean embedded) {
        try {
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded);
            Collection<String> fontFamilyNames = TrueTypeUtil.getFamilyNames(font);
            return new HashSet<String>(fontFamilyNames);
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(spec.families, spec.size, spec.fontWeight, spec.fontStyle);
    }

    public void flushCache() {
        this._fontFamilies.clear();
        this._fontFamilies.putAll(ITextFontResolver.createInitialFontMap());
        this._fontCache.clear();
    }

    public void flushFontFaceFonts() {
        this._fontCache.clear();
        Iterator<FontFamily> i = this._fontFamilies.values().iterator();
        while (i.hasNext()) {
            FontFamily family = i.next();
            family.getFontDescriptions().removeIf(FontDescription::isFromFontFace);
            if (!family.getFontDescriptions().isEmpty()) continue;
            i.remove();
        }
    }

    public void importFontFaces(List<FontFaceRule> fontFaces) {
        for (FontFaceRule rule : fontFaces) {
            CalculatedStyle style = rule.getCalculatedStyle();
            FSDerivedValue src = style.valueByName(CSSName.SRC);
            if (src == IdentValue.NONE) continue;
            byte[] font1 = this.userAgent.getBinaryResource(src.asString());
            if (font1 == null) {
                XRLog.exception((String)("Could not load font " + src.asString()));
                continue;
            }
            byte[] font2 = null;
            FSDerivedValue metricsSrc = style.valueByName(CSSName.FS_FONT_METRIC_SRC);
            if (metricsSrc != IdentValue.NONE && (font2 = this.userAgent.getBinaryResource(metricsSrc.asString())) == null) {
                XRLog.exception((String)("Could not load font metric data " + src.asString()));
                continue;
            }
            if (font2 != null) {
                byte[] t = font1;
                font1 = font2;
                font2 = t;
            }
            boolean embedded = style.isIdent(CSSName.FS_PDF_FONT_EMBED, IdentValue.EMBED);
            String encoding = style.getStringProperty(CSSName.FS_PDF_FONT_ENCODING);
            String fontFamily = null;
            IdentValue fontWeight = null;
            IdentValue fontStyle = null;
            if (rule.hasFontFamily()) {
                fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
            }
            if (rule.hasFontWeight()) {
                fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
            }
            if (rule.hasFontStyle()) {
                fontStyle = style.getIdent(CSSName.FONT_STYLE);
            }
            try {
                this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), encoding, embedded, font1, font2);
            }
            catch (DocumentException | IOException e) {
                XRLog.exception((String)("Could not load font " + src.asString()), (Throwable)e);
            }
        }
    }

    public void addFontDirectory(String dir, boolean embedded) throws DocumentException, IOException {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = Objects.requireNonNull(f.listFiles((dir1, name) -> {
                String lower = name.toLowerCase();
                return lower.endsWith(".otf") || lower.endsWith(".ttf");
            }))) {
                this.addFont(file.getAbsolutePath(), embedded);
            }
        }
    }

    public void addFont(String path, boolean embedded) throws DocumentException, IOException {
        this.addFont(path, "Cp1252", embedded);
    }

    public void addFont(String path, String encoding, boolean embedded) throws DocumentException, IOException {
        this.addFont(path, encoding, embedded, null);
    }

    public void addFont(String path, String encoding, boolean embedded, String pathToPFB) throws DocumentException, IOException {
        this.addFont(path, null, encoding, embedded, pathToPFB);
    }

    public void addFont(String path, String fontFamilyNameOverride, String encoding, boolean embedded, String pathToPFB) throws DocumentException, IOException {
        String lower = path.toLowerCase();
        if (lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.contains(".ttc,")) {
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded);
            Collection<String> fontFamilyNames = fontFamilyNameOverride != null ? Collections.singletonList(fontFamilyNameOverride) : TrueTypeUtil.getFamilyNames(font);
            for (String fontFamilyName : fontFamilyNames) {
                FontFamily fontFamily = this.getFontFamily(fontFamilyName);
                FontDescription description = new FontDescription(font);
                try {
                    TrueTypeUtil.populateDescription(path, font, description);
                }
                catch (Exception e) {
                    throw new XRRuntimeException(e.getMessage(), (Throwable)e);
                }
                fontFamily.addFontDescription(description);
            }
        } else if (lower.endsWith(".ttc")) {
            String[] names = BaseFont.enumerateTTCNames((String)path);
            for (int i = 0; i < names.length; ++i) {
                this.addFont(path + "," + i, fontFamilyNameOverride, encoding, embedded, null);
            }
        } else if (lower.endsWith(".afm") || lower.endsWith(".pfm")) {
            if (embedded && pathToPFB == null) {
                throw new IOException("When embedding a font, path to PFB/PFA file must be specified");
            }
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded, (boolean)false, null, (byte[])this.readFile(pathToPFB));
            String fontFamilyName = fontFamilyNameOverride != null ? fontFamilyNameOverride : font.getFamilyFontName()[0][3];
            FontFamily fontFamily = this.getFontFamily(fontFamilyName);
            FontDescription description = new FontDescription(font);
            fontFamily.addFontDescription(description);
        } else {
            throw new IOException("Unsupported font type");
        }
    }

    private void addFontFaceFont(String fontFamilyNameOverride, IdentValue fontWeightOverride, IdentValue fontStyleOverride, String uri, String encoding, boolean embedded, byte[] afmttf, byte[] pfb) throws DocumentException, IOException {
        String lower = uri.toLowerCase();
        if (lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.contains(".ttc,")) {
            BaseFont font = BaseFont.createFont((String)uri, (String)encoding, (boolean)embedded, (boolean)false, (byte[])afmttf, (byte[])pfb);
            Collection<String> fontFamilyNames = fontFamilyNameOverride != null ? Collections.singletonList(fontFamilyNameOverride) : TrueTypeUtil.getFamilyNames(font);
            for (String fontFamilyName : fontFamilyNames) {
                FontFamily fontFamily = this.getFontFamily(fontFamilyName);
                FontDescription description = new FontDescription(font);
                try {
                    TrueTypeUtil.populateDescription(uri, afmttf, font, description);
                }
                catch (Exception e) {
                    throw new XRRuntimeException(e.getMessage(), (Throwable)e);
                }
                description.setFromFontFace(true);
                if (fontWeightOverride != null) {
                    description.setWeight(ITextFontResolver.convertWeightToInt(fontWeightOverride));
                }
                if (fontStyleOverride != null) {
                    description.setStyle(fontStyleOverride);
                }
                fontFamily.addFontDescription(description);
            }
        } else if (lower.endsWith(".afm") || lower.endsWith(".pfm") || lower.endsWith(".pfb") || lower.endsWith(".pfa")) {
            if (embedded && pfb == null) {
                throw new IOException("When embedding a font, path to PFB/PFA file must be specified");
            }
            String name = uri.substring(0, uri.length() - 4) + ".afm";
            BaseFont font = BaseFont.createFont((String)name, (String)encoding, (boolean)embedded, (boolean)false, (byte[])afmttf, (byte[])pfb);
            String fontFamilyName = font.getFamilyFontName()[0][3];
            FontFamily fontFamily = this.getFontFamily(fontFamilyName);
            FontDescription description = new FontDescription(font);
            description.setFromFontFace(true);
            fontFamily.addFontDescription(description);
        } else {
            throw new IOException("Unsupported font type");
        }
    }

    private byte[] readFile(String path) throws IOException {
        return IOUtil.readBytes((Path)Paths.get(path, new String[0]));
    }

    private FontFamily getFontFamily(String fontFamilyName) {
        FontFamily fontFamily = this._fontFamilies.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily(fontFamilyName);
            this._fontFamilies.put(fontFamilyName, fontFamily);
        }
        return fontFamily;
    }

    private FSFont resolveFont(String[] families, float size, IdentValue weight, IdentValue style) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        if (families != null) {
            for (String family : families) {
                FSFont font = this.resolveFont(family, size, weight, style);
                if (font == null) continue;
                return font;
            }
        }
        return this.resolveFont("Serif", size, weight, style);
    }

    private String normalizeFontFamily(String fontFamily) {
        String result = fontFamily;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.equalsIgnoreCase("serif")) {
            result = "Serif";
        } else if (result.equalsIgnoreCase("sans-serif")) {
            result = "SansSerif";
        } else if (result.equalsIgnoreCase("monospace")) {
            result = "Monospaced";
        }
        return result;
    }

    private FSFont resolveFont(String fontFamily, float size, IdentValue weight, IdentValue style) {
        String normalizedFontFamily = this.normalizeFontFamily(fontFamily);
        String cacheKey = ITextFontResolver.getHashName(normalizedFontFamily, weight, style);
        FontDescription result = this._fontCache.get(cacheKey);
        if (result != null) {
            return new ITextFSFont(result, size);
        }
        FontFamily family = this._fontFamilies.get(normalizedFontFamily);
        if (family != null && (result = family.match(ITextFontResolver.convertWeightToInt(weight), style)) != null) {
            this._fontCache.put(cacheKey, result);
            return new ITextFSFont(result, size);
        }
        return null;
    }

    public static int convertWeightToInt(IdentValue weight) {
        if (weight == IdentValue.NORMAL) {
            return 400;
        }
        if (weight == IdentValue.BOLD) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_100) {
            return 100;
        }
        if (weight == IdentValue.FONT_WEIGHT_200) {
            return 200;
        }
        if (weight == IdentValue.FONT_WEIGHT_300) {
            return 300;
        }
        if (weight == IdentValue.FONT_WEIGHT_400) {
            return 400;
        }
        if (weight == IdentValue.FONT_WEIGHT_500) {
            return 500;
        }
        if (weight == IdentValue.FONT_WEIGHT_600) {
            return 600;
        }
        if (weight == IdentValue.FONT_WEIGHT_700) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_800) {
            return 800;
        }
        if (weight == IdentValue.FONT_WEIGHT_900) {
            return 900;
        }
        if (weight == IdentValue.LIGHTER) {
            return 400;
        }
        if (weight == IdentValue.BOLDER) {
            return 700;
        }
        throw new IllegalArgumentException("Cannot convert weight to integer: " + weight);
    }

    protected static String getHashName(String name, IdentValue weight, IdentValue style) {
        return name + "-" + weight + "-" + style;
    }

    private static Map<String, FontFamily> createInitialFontMap() {
        HashMap<String, FontFamily> result = new HashMap<String, FontFamily>();
        try {
            ITextFontResolver.addCourier(result);
            ITextFontResolver.addTimes(result);
            ITextFontResolver.addHelvetica(result);
            ITextFontResolver.addSymbol(result);
            ITextFontResolver.addZapfDingbats(result);
            if (ITextFontResolver.class.getClassLoader().getResource("com/lowagie/text/pdf/fonts/cjkfonts.properties") != null) {
                ITextFontResolver.addCJKFonts(result);
            }
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    private static BaseFont createFont(String name) throws DocumentException, IOException {
        return ITextFontResolver.createFont(name, "winansi", true);
    }

    private static BaseFont createFont(String name, String encoding, boolean embedded) throws DocumentException, IOException {
        return BaseFont.createFont((String)name, (String)encoding, (boolean)embedded);
    }

    private static void addCourier(Map<String, FontFamily> result) throws DocumentException, IOException {
        FontFamily courier = new FontFamily("Courier");
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier-BoldOblique"), IdentValue.OBLIQUE, 700));
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier-Oblique"), IdentValue.OBLIQUE, 400));
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier-Bold"), IdentValue.NORMAL, 700));
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier"), IdentValue.NORMAL, 400));
        result.put("DialogInput", courier);
        result.put("Monospaced", courier);
        result.put("Courier", courier);
    }

    private static void addTimes(Map<String, FontFamily> result) throws DocumentException, IOException {
        FontFamily times = new FontFamily("Times");
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-BoldItalic"), IdentValue.ITALIC, 700));
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-Italic"), IdentValue.ITALIC, 400));
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-Bold"), IdentValue.NORMAL, 700));
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-Roman"), IdentValue.NORMAL, 400));
        result.put("Serif", times);
        result.put("TimesRoman", times);
    }

    private static void addHelvetica(Map<String, FontFamily> result) throws DocumentException, IOException {
        FontFamily helvetica = new FontFamily("Helvetica");
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica-BoldOblique"), IdentValue.OBLIQUE, 700));
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica-Oblique"), IdentValue.OBLIQUE, 400));
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica-Bold"), IdentValue.NORMAL, 700));
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica"), IdentValue.NORMAL, 400));
        result.put("Dialog", helvetica);
        result.put("SansSerif", helvetica);
        result.put("Helvetica", helvetica);
    }

    private static void addSymbol(Map<String, FontFamily> result) throws DocumentException, IOException {
        FontFamily fontFamily = new FontFamily("Symbol");
        fontFamily.addFontDescription(new FontDescription(ITextFontResolver.createFont("Symbol", "Cp1252", false), IdentValue.NORMAL, 400));
        result.put("Symbol", fontFamily);
    }

    private static void addZapfDingbats(Map<String, FontFamily> result) throws DocumentException, IOException {
        FontFamily fontFamily = new FontFamily("ZapfDingbats");
        fontFamily.addFontDescription(new FontDescription(ITextFontResolver.createFont("ZapfDingbats", "Cp1252", false), IdentValue.NORMAL, 400));
        result.put("ZapfDingbats", fontFamily);
    }

    private static void addCJKFonts(Map<String, FontFamily> fontFamilyMap) throws DocumentException, IOException {
        for (String[] cjkFont : cjkFonts) {
            String fontFamilyName = cjkFont[0];
            String fontName = cjkFont[1];
            String encoding = cjkFont[2];
            ITextFontResolver.addCJKFont(fontFamilyName, fontName, encoding, fontFamilyMap);
        }
    }

    private static void addCJKFont(String fontFamilyName, String fontName, String encoding, Map<String, FontFamily> fontFamilyMap) throws DocumentException, IOException {
        FontFamily fontFamily = new FontFamily(fontFamilyName);
        fontFamily.addFontDescription(new FontDescription(ITextFontResolver.createFont(fontName + ",BoldItalic", encoding, false), IdentValue.OBLIQUE, 700));
        fontFamily.addFontDescription(new FontDescription(ITextFontResolver.createFont(fontName + ",Italic", encoding, false), IdentValue.OBLIQUE, 400));
        fontFamily.addFontDescription(new FontDescription(ITextFontResolver.createFont(fontName + ",Bold", encoding, false), IdentValue.NORMAL, 700));
        fontFamily.addFontDescription(new FontDescription(ITextFontResolver.createFont(fontName, encoding, false), IdentValue.NORMAL, 400));
        fontFamilyMap.put(fontFamilyName, fontFamily);
    }

    private static class FontFamily {
        private final String _name;
        private final List<FontDescription> _fontDescriptions = new ArrayList<FontDescription>();
        private static final int SM_EXACT = 1;
        private static final int SM_LIGHTER_OR_DARKER = 2;
        private static final int SM_DARKER_OR_LIGHTER = 3;

        private FontFamily(String name) {
            this._name = name;
        }

        private List<FontDescription> getFontDescriptions() {
            return this._fontDescriptions;
        }

        public void addFontDescription(FontDescription description) {
            this._fontDescriptions.add(description);
            this._fontDescriptions.sort(Comparator.comparingInt(FontDescription::getWeight));
        }

        public String getName() {
            return this._name;
        }

        public FontDescription match(int desiredWeight, IdentValue style) {
            FontDescription result;
            ArrayList<FontDescription> candidates = new ArrayList<FontDescription>();
            for (FontDescription description : this._fontDescriptions) {
                if (description.getStyle() != style) continue;
                candidates.add(description);
            }
            if (candidates.isEmpty()) {
                if (style == IdentValue.ITALIC) {
                    return this.match(desiredWeight, IdentValue.OBLIQUE);
                }
                if (style == IdentValue.OBLIQUE) {
                    return this.match(desiredWeight, IdentValue.NORMAL);
                }
                candidates.addAll(this._fontDescriptions);
            }
            if ((result = this.findByWeight(candidates, desiredWeight, 1)) != null) {
                return result;
            }
            if (desiredWeight <= 500) {
                return this.findByWeight(candidates, desiredWeight, 2);
            }
            return this.findByWeight(candidates, desiredWeight, 3);
        }

        private FontDescription findByWeight(List<FontDescription> matches, int desiredWeight, int searchMode) {
            if (searchMode == 1) {
                for (FontDescription description : matches) {
                    if (description.getWeight() != desiredWeight) continue;
                    return description;
                }
                return null;
            }
            if (searchMode == 2) {
                int offset;
                FontDescription description = null;
                for (offset = 0; offset < matches.size() && (description = matches.get(offset)).getWeight() <= desiredWeight; ++offset) {
                }
                if (offset > 0 && description.getWeight() > desiredWeight) {
                    return matches.get(offset - 1);
                }
                return description;
            }
            if (searchMode == 3) {
                int offset;
                FontDescription description = null;
                for (offset = matches.size() - 1; offset >= 0 && (description = matches.get(offset)).getWeight() >= desiredWeight; --offset) {
                }
                if (offset != matches.size() - 1 && description.getWeight() < desiredWeight) {
                    return matches.get(offset + 1);
                }
                return description;
            }
            return null;
        }
    }

    public static class FontDescription {
        private IdentValue _style;
        private int _weight;
        private BaseFont _font;
        private float _underlinePosition;
        private float _underlineThickness;
        private float _yStrikeoutSize;
        private float _yStrikeoutPosition;
        private boolean _isFromFontFace;

        public FontDescription() {
        }

        public FontDescription(BaseFont font) {
            this(font, IdentValue.NORMAL, 400);
        }

        public FontDescription(BaseFont font, IdentValue style, int weight) {
            this._font = font;
            this._style = style;
            this._weight = weight;
            this.setMetricDefaults();
        }

        public BaseFont getFont() {
            return this._font;
        }

        public void setFont(BaseFont font) {
            this._font = font;
        }

        public int getWeight() {
            return this._weight;
        }

        public void setWeight(int weight) {
            this._weight = weight;
        }

        public IdentValue getStyle() {
            return this._style;
        }

        public void setStyle(IdentValue style) {
            this._style = style;
        }

        public float getUnderlinePosition() {
            return this._underlinePosition;
        }

        public void setUnderlinePosition(float underlinePosition) {
            this._underlinePosition = underlinePosition;
        }

        public float getUnderlineThickness() {
            return this._underlineThickness;
        }

        public void setUnderlineThickness(float underlineThickness) {
            this._underlineThickness = underlineThickness;
        }

        public float getYStrikeoutPosition() {
            return this._yStrikeoutPosition;
        }

        public void setYStrikeoutPosition(float strikeoutPosition) {
            this._yStrikeoutPosition = strikeoutPosition;
        }

        public float getYStrikeoutSize() {
            return this._yStrikeoutSize;
        }

        public void setYStrikeoutSize(float strikeoutSize) {
            this._yStrikeoutSize = strikeoutSize;
        }

        private void setMetricDefaults() {
            this._underlinePosition = -50.0f;
            this._underlineThickness = 50.0f;
            int[] box = this._font.getCharBBox(120);
            if (box != null) {
                this._yStrikeoutPosition = box[3] / 2 + 50;
                this._yStrikeoutSize = 100.0f;
            } else {
                this._yStrikeoutPosition = this._font.getFontDescriptor(8, 1000.0f) / 3.0f;
            }
        }

        public boolean isFromFontFace() {
            return this._isFromFontFace;
        }

        public void setFromFontFace(boolean isFromFontFace) {
            this._isFromFontFace = isFromFontFace;
        }
    }
}

