/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.itextpdf.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class ToPDF {
    public static void main(String[] args) throws IOException, DocumentException {
        File f;
        String url;
        if (args.length != 2) {
            System.err.println("Usage: ... [url] [pdf]");
            System.exit(1);
        }
        if ((url = args[0]).indexOf("://") == -1 && (f = new File(url)).exists()) {
            url = f.toURI().toURL().toString();
        }
        ToPDF.createPDF(url, args[1]);
    }

    public static void createPDF(String url, String pdf) throws IOException, DocumentException {
        try (OutputStream os = Files.newOutputStream(Paths.get(pdf, new String[0]), new OpenOption[0]);){
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(url);
            renderer.layout();
            renderer.createPDF(os);
        }
    }
}

