/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.pdf.BaseFont;
import org.xhtmlrenderer.css.constants.IdentValue;

public class FontDescription {
    private static final int DEFAULT_FONT_WEIGHT = 400;
    private final IdentValue _style;
    private final BaseFont _font;
    private final Decorations _decorations;
    private final boolean _isFromFontFace;

    public FontDescription(BaseFont font) {
        this(font, false);
    }

    public FontDescription(BaseFont font, boolean isFromFontFace) {
        this(font, isFromFontFace, IdentValue.NORMAL);
    }

    public FontDescription(BaseFont font, IdentValue style, int weight) {
        this(font, false, style, FontDescription.defaultDecorations(font, weight));
    }

    public FontDescription(BaseFont font, boolean isFromFontFace, IdentValue style) {
        this(font, isFromFontFace, style, FontDescription.defaultDecorations(font, 400));
    }

    public FontDescription(BaseFont font, boolean isFromFontFace, IdentValue style, Decorations decorations) {
        this._font = font;
        this._isFromFontFace = isFromFontFace;
        this._style = style;
        this._decorations = decorations;
    }

    public BaseFont getFont() {
        return this._font;
    }

    public int getWeight() {
        return this._decorations.weight();
    }

    public IdentValue getStyle() {
        return this._style;
    }

    public float getUnderlinePosition() {
        return this._decorations.underlinePosition();
    }

    public float getUnderlineThickness() {
        return this._decorations.underlineThickness();
    }

    public float getYStrikeoutPosition() {
        return this._decorations.yStrikeoutPosition();
    }

    public float getYStrikeoutSize() {
        return this._decorations.yStrikeoutSize();
    }

    private static Decorations defaultDecorations(BaseFont font, int weight) {
        int underlinePosition = -50;
        int underlineThickness = 50;
        int[] box = font.getCharBBox(120);
        if (box != null) {
            float yStrikeoutPosition = (float)box[3] / 2.0f + 50.0f;
            float yStrikeoutSize = 100.0f;
            return new Decorations(weight, yStrikeoutSize, yStrikeoutPosition, underlinePosition, underlineThickness);
        }
        float yStrikeoutPosition = font.getFontDescriptor(8, 1000.0f) / 3.0f;
        return new Decorations(weight, 0.0f, yStrikeoutPosition, underlinePosition, underlineThickness);
    }

    public boolean isFromFontFace() {
        return this._isFromFontFace;
    }

    public String toString() {
        return String.format("Font %s:%s", this._font.getPostscriptFontName(), this.getWeight());
    }

    public record Decorations(int weight, float yStrikeoutSize, float yStrikeoutPosition, float underlinePosition, float underlineThickness) {
    }
}

