/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.time.Instant;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.util.Args;

public class CertTemplateData {
    private final X500Name subject;
    private final SubjectPublicKeyInfo publicKeyInfo;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String certprofileName;
    private final boolean serverkeygen;
    private final Extensions extensions;
    private final BigInteger certReqId;
    private boolean forCrossCert;

    public CertTemplateData(X500Name subject, SubjectPublicKeyInfo publicKeyInfo, Instant notBefore, Instant notAfter, Extensions extensions, String certprofileName) {
        this(subject, publicKeyInfo, notBefore, notAfter, extensions, certprofileName, null, false);
    }

    public CertTemplateData(X500Name subject, SubjectPublicKeyInfo publicKeyInfo, Instant notBefore, Instant notAfter, Extensions extensions, String certprofileName, BigInteger certReqId, boolean serverkeygen) {
        this.publicKeyInfo = publicKeyInfo;
        this.subject = (X500Name)Args.notNull((Object)subject, (String)"subject");
        this.certprofileName = Args.toNonBlankLower((String)certprofileName, (String)"certprofileName");
        this.extensions = extensions;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.certReqId = certReqId;
        this.serverkeygen = serverkeygen;
    }

    public boolean isForCrossCert() {
        return this.forCrossCert;
    }

    public void setForCrossCert(boolean forCrossCert) {
        this.forCrossCert = forCrossCert;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public boolean isServerkeygen() {
        return this.serverkeygen;
    }

    public Instant getNotBefore() {
        return this.notBefore;
    }

    public Instant getNotAfter() {
        return this.notAfter;
    }

    public String getCertprofileName() {
        return this.certprofileName;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public BigInteger getCertReqId() {
        return this.certReqId;
    }
}

