/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.server.CtLogPublicKeyFinder;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.ctlog.CtLog;
import org.xipki.security.ctlog.CtLogMessages;
import org.xipki.util.Args;
import org.xipki.util.Curl;
import org.xipki.util.DefaultCurl;
import org.xipki.util.Hex;
import org.xipki.util.JSON;
import org.xipki.util.StringUtil;
import org.xipki.util.http.SslContextConf;

public class CtLogClient {
    private static final Logger LOG = LoggerFactory.getLogger(CtLogClient.class);
    private final Curl curl;
    private final List<String> addPreChainUrls;

    public CtLogClient(List<String> serverUrls, SslContextConf sslContextConf) {
        Args.notEmpty(serverUrls, (String)"serverUrls");
        this.curl = new DefaultCurl();
        ((DefaultCurl)this.curl).setSslContextConf(sslContextConf);
        this.addPreChainUrls = new ArrayList<String>(serverUrls.size());
        for (String m : serverUrls) {
            String addPreChainUrl = m.endsWith("/") ? m + "ct/v1/add-pre-chain" : m + "/ct/v1/add-pre-chain";
            this.addPreChainUrls.add(addPreChainUrl);
        }
    }

    public CtLog.SignedCertificateTimestampList getCtLogScts(X509CertificateHolder precert, X509Cert caCert, List<X509Cert> certchain, CtLogPublicKeyFinder publicKeyFinder) throws OperationException {
        byte[] preCertTbsCert;
        byte[] issuerKeyHash;
        byte[] encodedPreCert;
        CtLogMessages.AddPreChainRequest request = new CtLogMessages.AddPreChainRequest();
        LinkedList<byte[]> chain = new LinkedList<byte[]>();
        request.setChain(chain);
        try {
            encodedPreCert = precert.getEncoded();
        }
        catch (IOException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        try {
            issuerKeyHash = HashAlgo.SHA256.hash((byte[][])new byte[][]{caCert.getSubjectPublicKeyInfo().getEncoded()});
        }
        catch (IOException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        try {
            preCertTbsCert = CtLog.getPreCertTbsCert((TBSCertificate)precert.toASN1Structure().getTBSCertificate());
        }
        catch (IOException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        chain.add(encodedPreCert);
        chain.add(caCert.getEncoded());
        if (certchain != null) {
            for (X509Cert m : certchain) {
                chain.add(m.getEncoded());
            }
        }
        byte[] content = JSON.toJSONBytes((Object)request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CTLog Request: {}", (Object)StringUtil.toUtf8String((byte[])content));
        }
        ArrayList<CtLog.SignedCertificateTimestamp> scts = new ArrayList<CtLog.SignedCertificateTimestamp>(this.addPreChainUrls.size());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        for (String url : this.addPreChainUrls) {
            PublicKey verifyKey;
            Curl.CurlResult res;
            try {
                res = this.curl.curlPost(url, false, headers, null, content);
            }
            catch (Exception ex) {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, "error while calling " + url + ": " + ex.getMessage());
            }
            byte[] respContent = Optional.ofNullable(res.getContent()).orElseThrow(() -> new OperationException(ErrorCode.SYSTEM_FAILURE, "server does not return any content while responding " + url));
            if (LOG.isDebugEnabled()) {
                LOG.debug("CTLog Response: {}", (Object)StringUtil.toUtf8String((byte[])respContent));
            }
            CtLogMessages.AddPreChainResponse resp = (CtLogMessages.AddPreChainResponse)JSON.parseObject((byte[])respContent, CtLogMessages.AddPreChainResponse.class);
            CtLog.DigitallySigned ds = CtLog.DigitallySigned.getInstance((byte[])resp.getSignature(), (AtomicInteger)new AtomicInteger(0));
            byte sctVersion = resp.getSct_version();
            byte[] logId = resp.getId();
            String hexLogId = Hex.encodeUpper((byte[])logId);
            long timestamp = resp.getTimestamp();
            byte[] extensions = resp.getExtensions();
            PublicKey publicKey = verifyKey = publicKeyFinder == null ? null : publicKeyFinder.getPublicKey(logId);
            if (verifyKey == null) {
                LOG.warn("could not find CtLog public key 0x{} to verify the SCT", (Object)hexLogId);
            } else {
                boolean sigValid;
                CtLog.SignatureAndHashAlgorithm algorithm = ds.getAlgorithm();
                String signAlgo = CtLogClient.getSignatureAlgo(algorithm);
                try {
                    Signature sig = Signature.getInstance(signAlgo, "BC");
                    sig.initVerify(verifyKey);
                    CtLog.update((Signature)sig, (byte)sctVersion, (long)timestamp, (byte[])extensions, (byte[])issuerKeyHash, (byte[])preCertTbsCert);
                    sigValid = sig.verify(ds.getSignature());
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException ex) {
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, "error verifying SCT signature");
                }
                if (sigValid) {
                    LOG.info("verified SCT signature with logId {} and timestamp {}", (Object)hexLogId, (Object)timestamp);
                } else {
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, "SCT signature is invalid");
                }
            }
            CtLog.SignedCertificateTimestamp sct = new CtLog.SignedCertificateTimestamp(sctVersion, logId, timestamp, extensions, ds);
            scts.add(sct);
        }
        return new CtLog.SignedCertificateTimestampList(new CtLog.SerializedSCT(scts));
    }

    private static String getSignatureAlgo(CtLog.SignatureAndHashAlgorithm algorithm) throws OperationException {
        String encAlgo;
        String hashName;
        switch (algorithm.getHash()) {
            case sha1: {
                hashName = "SHA1";
                break;
            }
            case sha256: {
                hashName = "SHA256";
                break;
            }
            case sha384: {
                hashName = "SHA384";
                break;
            }
            case sha512: {
                hashName = "SHA512";
                break;
            }
            default: {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, "unsupported hash algorithm " + algorithm.getHash());
            }
        }
        CtLog.SignatureAlgorithm signatureType = algorithm.getSignature();
        if (CtLog.SignatureAlgorithm.ecdsa == signatureType) {
            encAlgo = "ECDSA";
        } else if (CtLog.SignatureAlgorithm.rsa == signatureType) {
            encAlgo = "RSA";
        } else {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "unsupported signature algorithm " + algorithm.getSignature());
        }
        return hashName + "WITH" + encAlgo;
    }
}

