/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.server.CaServerConf;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;

public class CtLogPublicKeyFinder {
    private static final Logger LOG = LoggerFactory.getLogger(CtLogPublicKeyFinder.class);
    private final byte[][] logIds;
    private final PublicKey[] publicKeys;
    private final boolean withPublicKeys;

    public CtLogPublicKeyFinder(CaServerConf.CtLogConf conf) throws IOException {
        String keydirName = conf.getKeydir();
        File[] keyFiles = null;
        if (keydirName != null && !keydirName.isEmpty()) {
            keydirName = IoUtil.expandFilepath((String)keydirName, (boolean)true);
            keyFiles = new File(keydirName).listFiles(pathname -> {
                String name = pathname.getName();
                return pathname.isFile() && (name.endsWith(".pem") || name.endsWith(".der") || name.endsWith(".key") || name.endsWith(".publickey"));
            });
        }
        if (keyFiles == null || keyFiles.length == 0) {
            this.logIds = null;
            this.publicKeys = null;
            this.withPublicKeys = false;
            return;
        }
        int size = keyFiles.length;
        ArrayList<byte[]> logIdList = new ArrayList<byte[]>(size);
        ArrayList<PublicKey> publicKeyList = new ArrayList<PublicKey>(size);
        for (File m : keyFiles) {
            byte[] keyBytes = IoUtil.read((File)m, (boolean)true);
            keyBytes = X509Util.toDerEncoded((byte[])keyBytes);
            try {
                SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)keyBytes);
                byte[] logId = HashAlgo.SHA256.hash((byte[][])new byte[][]{spki.getEncoded()});
                PublicKey key = KeyUtil.generatePublicKey((SubjectPublicKeyInfo)spki);
                logIdList.add(logId);
                publicKeyList.add(key);
                LOG.info("loaded CtLog public key {}", (Object)m.getName());
            }
            catch (IOException | InvalidKeySpecException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not load CtLog public key " + m.getName()));
            }
        }
        this.logIds = (byte[][])logIdList.toArray((T[])new byte[0][0]);
        this.publicKeys = publicKeyList.toArray(new PublicKey[0]);
        this.withPublicKeys = this.logIds.length > 0;
    }

    public PublicKey getPublicKey(byte[] logId) {
        if (this.withPublicKeys) {
            for (int i = 0; i < this.logIds.length; ++i) {
                if (!Arrays.equals(logId, this.logIds[i])) continue;
                return this.publicKeys[i];
            }
        }
        return null;
    }
}

