/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.DataSourceMap;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public class IdentifiedCertPublisher
implements Closeable {
    private final PublisherEntry entry;
    private final CertPublisher certPublisher;

    public IdentifiedCertPublisher(PublisherEntry entry, CertPublisher certPublisher) {
        this.entry = (PublisherEntry)Args.notNull((Object)entry, (String)"entry");
        this.certPublisher = (CertPublisher)Args.notNull((Object)certPublisher, (String)"certPublisher");
    }

    public void initialize(DataSourceMap datasourceConfs) throws CertPublisherException {
        this.certPublisher.initialize(this.entry.getConf(), datasourceConfs);
    }

    public boolean caAdded(X509Cert caCert) {
        return this.certPublisher.caAdded(caCert);
    }

    public boolean certificateAdded(CertificateInfo certInfo) {
        return this.certPublisher.certificateAdded(certInfo);
    }

    public boolean certificateRevoked(X509Cert caCert, CertWithDbId cert, String certprofile, CertRevocationInfo revInfo) {
        return this.certPublisher.certificateRevoked(caCert, cert, certprofile, revInfo);
    }

    public boolean crlAdded(X509Cert caCert, X509CRLHolder crl) {
        return this.certPublisher.crlAdded(caCert, crl);
    }

    public PublisherEntry getDbEntry() {
        return this.entry;
    }

    public NameId getIdent() {
        return this.entry.getIdent();
    }

    public boolean isHealthy() {
        return this.certPublisher.isHealthy();
    }

    public boolean caRevoked(X509Cert caCert, CertRevocationInfo revocationInfo) {
        return this.certPublisher.caRevoked(caCert, revocationInfo);
    }

    public boolean caUnrevoked(X509Cert caCert) {
        return this.certPublisher.caUnrevoked(caCert);
    }

    public boolean certificateUnrevoked(X509Cert caCert, CertWithDbId cert) {
        return this.certPublisher.certificateUnrevoked(caCert, cert);
    }

    public boolean certificateRemoved(X509Cert caCert, CertWithDbId cert) {
        return this.certPublisher.certificateRemoved(caCert, cert);
    }

    @Override
    public void close() {
        this.certPublisher.close();
    }

    public boolean publishsGoodCert() {
        return this.certPublisher.publishsGoodCert();
    }
}

