/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionSpec;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.NotAfterMode;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertprofileUtil;
import org.xipki.pki.BadCertTemplateException;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Validity;

public class IdentifiedCertprofile
implements Closeable {
    private final CertprofileEntry dbEntry;
    private final Certprofile certprofile;

    public IdentifiedCertprofile(CertprofileEntry dbEntry, Certprofile certprofile) throws CertprofileException {
        this.dbEntry = (CertprofileEntry)Args.notNull((Object)dbEntry, (String)"dbEntry");
        this.certprofile = (Certprofile)Args.notNull((Object)certprofile, (String)"certprofile");
        this.certprofile.initialize(dbEntry.getConf());
        if (this.certprofile.getCertLevel() != Certprofile.CertLevel.EndEntity && this.certprofile.hasNoWellDefinedExpirationDate()) {
            throw new CertprofileException("CA certificate is not allowed to have notAfter 99991231235959Z");
        }
    }

    public NameId getIdent() {
        return this.dbEntry.getIdent();
    }

    public Certprofile getCertprofile() {
        return this.certprofile;
    }

    public CertprofileEntry getDbEntry() {
        return this.dbEntry;
    }

    public Certprofile.X509CertVersion getVersion() {
        return this.certprofile.getVersion();
    }

    public List<SignAlgo> getSignatureAlgorithms() {
        return this.certprofile.getSignatureAlgorithms();
    }

    public Instant getNotBefore(Instant notBefore) {
        return this.certprofile.getNotBefore(notBefore);
    }

    public Validity getValidity() {
        return this.certprofile.getValidity();
    }

    public boolean hasNoWellDefinedExpirationDate() {
        return this.certprofile.hasNoWellDefinedExpirationDate();
    }

    public NotAfterMode getNotAfterMode() {
        return this.certprofile.getNotAfterMode();
    }

    public Certprofile.SubjectInfo getSubject(X500Name requestedSubject, SubjectPublicKeyInfo publicKeyInfo) throws CertprofileException, BadCertTemplateException {
        ASN1ObjectIdentifier[] countryOids;
        Certprofile.SubjectInfo subjectInfo = this.certprofile.getSubject(requestedSubject, publicKeyInfo);
        if (this.certprofile.getCertDomain() == Certprofile.CertDomain.CABForumBR) {
            X500Name subject = subjectInfo.getGrantedSubject();
            if (this.getCertLevel() == Certprofile.CertLevel.EndEntity) {
                ASN1ObjectIdentifier[] includeSubjectFields;
                CertificatePolicies policies = this.certprofile.getCertificatePolicies();
                ASN1ObjectIdentifier policyId = null;
                if (policies != null) {
                    for (PolicyInformation m : policies.getPolicyInformation()) {
                        ASN1ObjectIdentifier pid = m.getPolicyIdentifier();
                        if (!ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((ASN1Primitive)pid) && !ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((ASN1Primitive)pid) && !ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((ASN1Primitive)pid)) continue;
                        policyId = pid;
                        break;
                    }
                }
                if (this.containsRdn(subject, ObjectIdentifiers.DN.street) && !this.containsRdn(subject, ObjectIdentifiers.DN.O) && !this.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !this.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:street is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (this.containsRdn(subject, ObjectIdentifiers.DN.localityName)) {
                    if (!(this.containsRdn(subject, ObjectIdentifiers.DN.O) || this.containsRdn(subject, ObjectIdentifiers.DN.givenName) || this.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:localityName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!this.containsRdn(subject, ObjectIdentifiers.DN.ST) && (this.containsRdn(subject, ObjectIdentifiers.DN.O) || this.containsRdn(subject, ObjectIdentifiers.DN.givenName) || this.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:localityName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:stateOrProvinceName field is absent.");
                }
                if (this.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                    if (!(this.containsRdn(subject, ObjectIdentifiers.DN.O) || this.containsRdn(subject, ObjectIdentifiers.DN.givenName) || this.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:stateOrProvinceName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!this.containsRdn(subject, ObjectIdentifiers.DN.localityName) && (this.containsRdn(subject, ObjectIdentifiers.DN.O) || this.containsRdn(subject, ObjectIdentifiers.DN.givenName) || this.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:stateOrProvinceName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:localityName field is absent.");
                }
                if (this.containsRdn(subject, ObjectIdentifiers.DN.postalCode) && !this.containsRdn(subject, ObjectIdentifiers.DN.O) && !this.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !this.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:postalCode is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (!this.containsRdn(subject, ObjectIdentifiers.DN.C) && (this.containsRdn(subject, ObjectIdentifiers.DN.O) || this.containsRdn(subject, ObjectIdentifiers.DN.givenName) || this.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:countryCode is required if the subject:organizationName field, subject:givenName, and subject:surname field are present");
                }
                if (ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((ASN1Primitive)policyId)) {
                    ASN1ObjectIdentifier[] excludeSubjectFields;
                    for (ASN1ObjectIdentifier m : excludeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.givenName, ObjectIdentifiers.DN.surname, ObjectIdentifiers.DN.street, ObjectIdentifiers.DN.localityName, ObjectIdentifiers.DN.ST, ObjectIdentifiers.DN.postalCode}) {
                        if (!this.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is prohibited in domain validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((ASN1Primitive)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                        if (this.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in organization validated certificate");
                    }
                    if (!this.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !this.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in organization validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((ASN1Primitive)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C}) {
                        if (this.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in individual validated certificate");
                    }
                    if (!(this.containsRdn(subject, ObjectIdentifiers.DN.O) || this.containsRdn(subject, ObjectIdentifiers.DN.givenName) && this.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("at least one of subject:organizationName and (subject:givenName, subject:surName) is required in individual validated certificate");
                    }
                    if (!this.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !this.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in individual validated certificate");
                    }
                }
            } else {
                ASN1ObjectIdentifier[] requiredTypes;
                for (ASN1ObjectIdentifier m : requiredTypes = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.CN, ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                    if (this.containsRdn(subject, ObjectIdentifiers.DN.CN)) continue;
                    throw new BadCertTemplateException("missing " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " in subject");
                }
            }
        }
        for (ASN1ObjectIdentifier oid : countryOids = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C, ObjectIdentifiers.DN.countryOfCitizenship, ObjectIdentifiers.DN.countryOfResidence, ObjectIdentifiers.DN.jurisdictionOfIncorporationCountryName}) {
            RDN[] countryRdns = subjectInfo.getGrantedSubject().getRDNs(oid);
            if (countryRdns == null) continue;
            for (RDN rdn : countryRdns) {
                String textValue = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                if (SubjectDnSpec.isValidCountryAreaCode((String)textValue)) continue;
                String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
                if (name == null) {
                    name = oid.getId();
                }
                throw new BadCertTemplateException("invalid country/area code '" + textValue + "' in subject attribute " + name);
            }
        }
        return subjectInfo;
    }

    private boolean containsRdn(X500Name subject, ASN1ObjectIdentifier o) {
        RDN[] rdns = subject.getRDNs(o);
        return rdns != null && rdns.length != 0;
    }

    /*
     * WARNING - void declaration
     */
    public ExtensionValues getExtensions(X500Name requestedSubject, X500Name grantedSubject, Extensions requestedExtensions, SubjectPublicKeyInfo publicKeyInfo, PublicCaInfo publicCaInfo, X509Cert crlSignerCert, Instant notBefore, Instant notAfter) throws CertprofileException, BadCertTemplateException {
        Set usageOccs;
        Object value;
        ASN1ObjectIdentifier extType;
        Certprofile.ExtensionControl extControl;
        Args.notNull((Object)publicKeyInfo, (String)"publicKeyInfo");
        ExtensionValues values = new ExtensionValues();
        HashMap controls = new HashMap(this.certprofile.getExtensionControls());
        controls.remove(ObjectIdentifiers.Extn.id_SCTs);
        HashMap<ASN1ObjectIdentifier, Extension> requestedExtns = new HashMap<ASN1ObjectIdentifier, Extension>();
        if (requestedExtensions != null) {
            ASN1ObjectIdentifier[] oids;
            for (ASN1ObjectIdentifier m : oids = requestedExtensions.getExtensionOIDs()) {
                Certprofile.ExtensionControl control = (Certprofile.ExtensionControl)controls.get(m);
                if (control != null && !control.isPermittedInRequest()) continue;
                requestedExtns.put(m, requestedExtensions.getExtension(m));
            }
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.subjectKeyIdentifier)) != null) {
            SubjectKeyIdentifier value2;
            Extension reqExtn = (Extension)requestedExtns.get(extType);
            if (reqExtn == null) {
                SubjectKeyIdentifier value22 = this.certprofile.getSubjectKeyIdentifier(publicKeyInfo);
            } else {
                value2 = new SubjectKeyIdentifier(SubjectKeyIdentifier.getInstance((Object)reqExtn.getParsedValue()).getKeyIdentifier());
            }
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value2, extControl);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.authorityKeyIdentifier)) != null) {
            AuthorityKeyIdentifier value3 = null;
            if (this.certprofile.useIssuerAndSerialInAki()) {
                GeneralNames x509CaIssuer = new GeneralNames(new GeneralName(publicCaInfo.getIssuer()));
                value3 = new AuthorityKeyIdentifier(x509CaIssuer, publicCaInfo.getSerialNumber());
            } else {
                byte[] ikiValue = publicCaInfo.getSubjectKeyIdentifer();
                if (ikiValue != null) {
                    value3 = new AuthorityKeyIdentifier(ikiValue);
                }
            }
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value3, extControl);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.issuerAlternativeName)) != null) {
            GeneralNames value4 = publicCaInfo.getSubjectAltName();
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value4, extControl);
        }
        extType = Extension.authorityInfoAccess;
        extControl = (Certprofile.ExtensionControl)controls.remove(extType);
        CaUris caUris = publicCaInfo.getCaUris();
        if (extControl != null) {
            Certprofile.AuthorityInfoAccessControl aiaControl = this.certprofile.getAiaControl();
            List caIssuers = null;
            if (aiaControl != null && aiaControl.isIncludesCaIssuers()) {
                caIssuers = caUris.getCacertUris();
                IdentifiedCertprofile.assertAllUrisHasProtocol(caIssuers, aiaControl.getCaIssuersProtocols());
            }
            List ocspUris = null;
            if (aiaControl != null && aiaControl.isIncludesOcsp()) {
                ocspUris = caUris.getOcspUris();
                IdentifiedCertprofile.assertAllUrisHasProtocol(ocspUris, aiaControl.getOcspProtocols());
            }
            AuthorityInformationAccess value5 = null;
            if (CollectionUtil.isNotEmpty((Collection)caIssuers) || CollectionUtil.isNotEmpty((Collection)ocspUris)) {
                value5 = CaUtil.createAuthorityInformationAccess(caIssuers, ocspUris);
            }
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value5, extControl);
        }
        if (controls.containsKey(Extension.cRLDistributionPoints) || controls.containsKey(Extension.freshestCRL)) {
            Set protocols;
            List uris;
            X500Name crlSignerSubject = crlSignerCert == null ? null : crlSignerCert.getSubject();
            X500Name x500CaPrincipal = publicCaInfo.getSubject();
            extType = Extension.cRLDistributionPoints;
            extControl = (Certprofile.ExtensionControl)controls.remove(extType);
            if (extControl != null) {
                value = null;
                uris = caUris.getCrlUris();
                if (CollectionUtil.isNotEmpty((Collection)uris)) {
                    Certprofile.CrlDistributionPointsControl crlDistributionPointsControl = this.certprofile.getCrlDpControl();
                    protocols = crlDistributionPointsControl == null ? null : crlDistributionPointsControl.getProtocols();
                    IdentifiedCertprofile.assertAllUrisHasProtocol(uris, protocols);
                    value = CaUtil.createCrlDistributionPoints(uris, x500CaPrincipal, crlSignerSubject);
                }
                CertprofileUtil.addExtension(values, extType, value, extControl);
            }
            if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.freshestCRL)) != null) {
                value = null;
                uris = caUris.getDeltaCrlUris();
                if (CollectionUtil.isNotEmpty((Collection)uris)) {
                    Certprofile.CrlDistributionPointsControl crlDistributionPointsControl = this.certprofile.getFreshestCrlControl();
                    protocols = crlDistributionPointsControl == null ? null : crlDistributionPointsControl.getProtocols();
                    IdentifiedCertprofile.assertAllUrisHasProtocol(uris, protocols);
                    value = CaUtil.createCrlDistributionPoints(caUris.getDeltaCrlUris(), x500CaPrincipal, crlSignerSubject);
                }
                CertprofileUtil.addExtension(values, extType, value, extControl);
            }
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.basicConstraints)) != null) {
            BasicConstraints value3;
            Certprofile.CertLevel certLevel = this.certprofile.getCertLevel();
            if (certLevel == Certprofile.CertLevel.EndEntity) {
                BasicConstraints value6 = CaUtil.createBasicConstraints(Certprofile.CertLevel.EndEntity, null);
            } else {
                Object pathLen = this.certprofile.getPathLenBasicConstraint();
                Extension requestedExtn = (Extension)requestedExtns.get(extType);
                if (requestedExtn != null) {
                    int reqPathLen;
                    BasicConstraints basicConstraints = BasicConstraints.getInstance((Object)requestedExtn.getParsedValue());
                    if (!basicConstraints.isCA()) {
                        throw new CertprofileException("could not enroll a CA certificate for an EndEntity request");
                    }
                    if (basicConstraints.getPathLenConstraint() != null && (reqPathLen = basicConstraints.getPathLenConstraint().intValue()) >= 0 && (pathLen == null || reqPathLen < (Integer)pathLen)) {
                        pathLen = reqPathLen;
                    }
                }
                value3 = CaUtil.createBasicConstraints(certLevel, (Integer)pathLen);
            }
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value3, extControl);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.keyUsage)) != null) {
            HashSet<KeyUsage> usages = new HashSet<KeyUsage>();
            usageOccs = this.certprofile.getKeyUsage();
            for (Certprofile.KeyUsageControl k : usageOccs) {
                if (!k.isRequired()) continue;
                usages.add(k.getKeyUsage());
            }
            CertprofileUtil.addRequestedKeyusage(usages, requestedExtns, usageOccs);
            value = X509Util.createKeyUsage(usages);
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value, extControl);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.extendedKeyUsage)) != null) {
            LinkedList<ASN1ObjectIdentifier> usages = new LinkedList<ASN1ObjectIdentifier>();
            usageOccs = this.certprofile.getExtendedKeyUsages();
            for (Certprofile.KeyUsageControl k : usageOccs) {
                if (!k.isRequired()) continue;
                usages.add(k.getExtKeyUsage());
            }
            CertprofileUtil.addRequestedExtKeyusage(usages, requestedExtns, usageOccs);
            if (extControl.isCritical() && usages.contains(ObjectIdentifiers.XKU.id_kp_anyExtendedKeyUsage)) {
                extControl = new Certprofile.ExtensionControl(false, extControl.isRequired(), extControl.getInRequest());
            }
            if (!extControl.isCritical() && usages.contains(ObjectIdentifiers.XKU.id_kp_timeStamping)) {
                extControl = new Certprofile.ExtensionControl(true, extControl.isRequired(), extControl.getInRequest());
            }
            value = X509Util.createExtendedUsage(usages);
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value, extControl);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = ObjectIdentifiers.Extn.id_extension_pkix_ocsp_nocheck)) != null) {
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)DERNull.INSTANCE, extControl);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.subjectInfoAccess)) != null) {
            ASN1Sequence value7 = CertprofileUtil.createSubjectInfoAccess(requestedExtns, this.certprofile.getSubjectInfoAccessModes());
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value7, extControl);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.certificatePolicies)) != null) {
            CertificatePolicies value8 = this.certprofile.getCertificatePolicies();
            CertprofileUtil.addExtension(values, extType, (ASN1Encodable)value8, extControl);
        }
        ExtensionValues subvalues = this.certprofile.getExtensions(Collections.unmodifiableMap(controls), requestedSubject, grantedSubject, requestedExtns, notBefore, notAfter, publicCaInfo);
        HashSet extTypes = new HashSet(controls.keySet());
        for (Object type : extTypes) {
            void var19_41;
            Extension reqExt;
            extControl = (Certprofile.ExtensionControl)controls.get(type);
            ExtensionValue extensionValue = subvalues.getExtensionValue((ASN1ObjectIdentifier)type);
            if (extensionValue == null && extControl.isPermittedInRequest() && (reqExt = (Extension)requestedExtns.get(type)) != null) {
                ExtensionValue extensionValue2 = new ExtensionValue(extControl.isCritical(), reqExt.getParsedValue());
            }
            if (var19_41 == null) continue;
            CertprofileUtil.addExtension(values, (ASN1ObjectIdentifier)type, (ExtensionValue)var19_41, extControl);
            controls.remove(type);
        }
        HashSet<ASN1ObjectIdentifier> unprocessedExtTypes = new HashSet<ASN1ObjectIdentifier>();
        for (Map.Entry entry : controls.entrySet()) {
            if (!((Certprofile.ExtensionControl)entry.getValue()).isRequired()) continue;
            unprocessedExtTypes.add((ASN1ObjectIdentifier)entry.getKey());
        }
        if (CollectionUtil.isNotEmpty(unprocessedExtTypes)) {
            throw new CertprofileException("could not add required extensions " + CertprofileUtil.toString(unprocessedExtTypes));
        }
        if (this.certprofile.getCertDomain() == Certprofile.CertDomain.CABForumBR && this.getCertLevel() == Certprofile.CertLevel.EndEntity) {
            boolean bl;
            GeneralName[] genNames;
            String commonName = X509Util.getCommonName((X500Name)grantedSubject);
            boolean bl2 = commonName == null;
            for (GeneralName m : genNames = GeneralNames.getInstance((Object)values.getExtensionValue(Extension.subjectAlternativeName).getValue()).getNames()) {
                if (2 == m.getTagNo()) {
                    String domain = ASN1IA5String.getInstance((Object)m.getName()).getString();
                    if (!bl && domain.equals(commonName)) {
                        bl = true;
                    }
                    if (domain.indexOf(95) != -1) {
                        throw new BadCertTemplateException("invalid DNSName " + domain);
                    }
                    if (ExtensionSpec.isValidPublicDomain((String)domain)) continue;
                    throw new BadCertTemplateException("invalid DNSName " + domain);
                }
                if (7 != m.getTagNo()) continue;
                byte[] octets = DEROctetString.getInstance((Object)m.getName()).getOctets();
                if (octets.length == 4) {
                    String ipAddressText;
                    if (bl || !(ipAddressText = (0xFF & octets[0]) + "." + (0xFF & octets[1]) + "." + (0xFF & octets[2]) + "." + (0xFF & octets[3])).equals(commonName)) continue;
                    bl = true;
                    continue;
                }
                if (octets.length == 8) {
                    if (bl) continue;
                    ArrayList<Integer> positions = new ArrayList<Integer>(7);
                    int n = commonName.length();
                    for (int i = 0; i < n; ++i) {
                        if (commonName.charAt(i) != ':') continue;
                        positions.add(i);
                    }
                    if (positions.size() != 7) continue;
                    String[] blocks = new String[8];
                    blocks[0] = commonName.substring(0, (Integer)positions.get(0));
                    for (int i = 0; i < 6; ++i) {
                        blocks[i + 1] = commonName.substring((Integer)positions.get(i) + 1, (Integer)positions.get(i + 1));
                    }
                    blocks[7] = commonName.substring((Integer)positions.get(6) + 1);
                    byte[] commonNameBytes = new byte[16];
                    for (int i = 0; i < 8; ++i) {
                        String block = blocks[i];
                        int blen = block.length();
                        if (blen == 1 | blen == 2) {
                            commonNameBytes[i * 2 + 1] = (byte)Integer.parseInt(block, 16);
                            continue;
                        }
                        if (blen == 3 | blen == 4) {
                            commonNameBytes[i * 2] = (byte)Integer.parseInt(block.substring(0, blen - 2), 16);
                            commonNameBytes[i * 2 + 1] = (byte)Integer.parseInt(block.substring(blen - 2), 16);
                            continue;
                        }
                        if (blen == 0) continue;
                        throw new BadCertTemplateException("invalid IP address in commonName " + commonName);
                    }
                    if (!Arrays.equals(commonNameBytes, octets)) continue;
                    bl = true;
                    continue;
                }
                throw new BadCertTemplateException("invalid IP address " + Hex.toHexString((byte[])octets));
            }
            if (!bl) {
                throw new BadCertTemplateException("content of subject:commonName is not included in extension:SubjectAlternativeNames");
            }
        }
        return values;
    }

    private static void assertAllUrisHasProtocol(List<String> uris, Set<String> protocols) throws CertprofileException {
        if (protocols == null || uris == null) {
            return;
        }
        for (String uri : uris) {
            boolean validUri = false;
            for (String protocol : protocols) {
                if (!uri.startsWith(protocol + ":")) continue;
                validUri = true;
                break;
            }
            if (validUri) continue;
            throw new CertprofileException("URL '" + uri + "' does not have any of protocols " + protocols);
        }
    }

    public Certprofile.CertLevel getCertLevel() {
        return this.certprofile.getCertLevel();
    }

    public KeypairGenControl getKeypairGenControl() {
        return this.certprofile.getKeypairGenControl();
    }

    public String getSerialNumberMode() {
        return this.certprofile.getSerialNumberMode();
    }

    public BigInteger generateSerialNumber(X500Name caSubject, SubjectPublicKeyInfo caPublicKeyInfo, X500Name requestSubject, SubjectPublicKeyInfo publicKeyInfo, ConfPairs caExtraControl) throws CertprofileException {
        return this.certprofile.generateSerialNumber(caSubject, caPublicKeyInfo, requestSubject, publicKeyInfo, caExtraControl);
    }

    public SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo publicKey) throws CertprofileException, BadCertTemplateException {
        return this.certprofile.checkPublicKey((SubjectPublicKeyInfo)Args.notNull((Object)publicKey, (String)"publicKey"));
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier(SubjectPublicKeyInfo publicKey) throws CertprofileException {
        return this.certprofile.getSubjectKeyIdentifier(publicKey);
    }

    @Override
    public void close() {
        if (this.certprofile != null) {
            this.certprofile.close();
        }
    }

    public Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> getExtensionControls() {
        return this.certprofile.getExtensionControls();
    }

    public Integer getPathLenBasicConstraint() {
        return this.certprofile.getPathLenBasicConstraint();
    }

    public int getMaxCertSize() {
        return this.certprofile.getMaxCertSize();
    }
}

