/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.util.Set;
import org.xipki.ca.api.DataSourceMap;
import org.xipki.ca.api.kpgen.KeypairGenerator;
import org.xipki.ca.api.kpgen.KeypairGeneratorFactory;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.server.kpgen.KeypoolKeypairGenerator;
import org.xipki.ca.server.kpgen.P11KeypairGenerator;
import org.xipki.ca.server.kpgen.SoftwareKeypairGenerator;
import org.xipki.security.SecurityFactory;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.util.Args;
import org.xipki.util.exception.ObjectCreationException;

public class KeypairGenEntryWrapper {
    private KeypairGenEntry dbEntry;
    private KeypairGenerator generator;

    public void setDbEntry(KeypairGenEntry dbEntry) {
        this.dbEntry = (KeypairGenEntry)Args.notNull((Object)dbEntry, (String)"dbEntry");
    }

    public void init(SecurityFactory securityFactory, P11CryptServiceFactory p11CryptServiceFactory, Set<KeypairGeneratorFactory> factories, int shardId, DataSourceMap dataSourceMap) throws ObjectCreationException {
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.dbEntry.faulty(true);
        String type = this.dbEntry.getType();
        if ("KEYPOOL".equalsIgnoreCase(type)) {
            this.generator = new KeypoolKeypairGenerator();
            ((KeypoolKeypairGenerator)this.generator).setShardId(shardId);
            ((KeypoolKeypairGenerator)this.generator).setDatasources(dataSourceMap);
        } else if ("SOFTWARE".equalsIgnoreCase(type)) {
            this.generator = new SoftwareKeypairGenerator(securityFactory.getRandom4Key());
        } else if ("PKCS11".equalsIgnoreCase(type)) {
            this.generator = new P11KeypairGenerator(p11CryptServiceFactory);
        } else {
            for (KeypairGeneratorFactory factory : factories) {
                if (!factory.canCreateKeypairGenerator(type)) continue;
                this.generator = factory.newKeypairGenerator(type, this.dbEntry.getConf(), securityFactory);
                break;
            }
            if (this.generator == null) {
                throw new ObjectCreationException("unknown keypairGen type " + type);
            }
        }
        try {
            this.generator.initialize(this.dbEntry.getConf());
        }
        catch (XiSecurityException ex) {
            throw new ObjectCreationException("error initializing keypair generator " + this.dbEntry.getName(), (Throwable)ex);
        }
        this.generator.setName(this.dbEntry.getName());
        this.dbEntry.faulty(false);
    }

    public KeypairGenEntry getDbEntry() {
        return this.dbEntry;
    }

    public KeypairGenerator getGenerator() {
        return this.generator;
    }

    public boolean isHealthy() {
        return this.generator != null && this.generator.isHealthy();
    }
}

