/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.kpgen;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.DataSourceMap;
import org.xipki.ca.api.kpgen.KeypairGenerator;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.XiSecurityException;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class KeypoolKeypairGenerator
extends KeypairGenerator {
    private int shardId;
    private KeypoolQueryExecutor queryExecutor;
    private SecretKey aes128key;
    private SecretKey aes192key;
    private SecretKey aes256key;
    private Cipher cipher;
    private DataSourceMap datasources;
    private final Map<String, Integer> keyspecToId = new HashMap<String, Integer>();

    public void setShardId(int shardId) {
        this.shardId = shardId;
    }

    public int getShardId() {
        return this.shardId;
    }

    public void setDatasources(DataSourceMap datasources) {
        this.datasources = datasources;
    }

    protected void initialize0(ConfPairs conf) throws XiSecurityException {
        Args.notNull((Object)conf, (String)"conf");
        String datasourceName = conf.value("datasource");
        DataSourceWrapper datasource = null;
        if (datasourceName != null) {
            datasource = this.datasources.getDataSource(datasourceName);
        }
        if (datasource == null) {
            throw new XiSecurityException("no datasource named '" + datasourceName + "' is specified");
        }
        try {
            this.queryExecutor = new KeypoolQueryExecutor(datasource, this.shardId);
            this.keyspecToId.clear();
            this.keyspecToId.putAll(this.queryExecutor.getKeyspecs());
            HashSet<String> set = new HashSet<String>();
            for (String m : this.keyspecs) {
                if (!this.keyspecToId.containsKey(m)) continue;
                set.add(m);
            }
            this.keyspecs.clear();
            this.keyspecs.addAll(set);
        }
        catch (DataAccessException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
        String password = conf.value("password");
        if (StringUtil.isBlank((String)password)) {
            throw new IllegalArgumentException("property password not defined");
        }
        try {
            int[] keyLengths;
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            char[] passwordChars = password.toCharArray();
            for (int keyLength : keyLengths = new int[]{128, 192, 256}) {
                PBEKeySpec spec = new PBEKeySpec(passwordChars, "ENC".getBytes(StandardCharsets.UTF_8), 10000, keyLength);
                SecretKeySpec key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
                if (keyLength == 128) {
                    this.aes128key = key;
                    continue;
                }
                if (keyLength == 192) {
                    this.aes192key = key;
                    continue;
                }
                this.aes256key = key;
            }
            this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (Exception ex) {
            throw new IllegalStateException("could not initialize Cipher", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PrivateKeyInfo generateKeypair(String keyspec) throws XiSecurityException {
        byte[] plain;
        SecretKey key;
        CipherData cd;
        Integer keyspecId = this.keyspecToId.get(keyspec);
        if (keyspecId == null) {
            return null;
        }
        Integer n = keyspecId;
        synchronized (n) {
            try {
                cd = this.queryExecutor.nextKeyData(keyspecId);
            }
            catch (DataAccessException ex) {
                throw new XiSecurityException((Throwable)ex);
            }
        }
        if (cd == null) {
            throw new XiSecurityException("found no keypair of spec " + keyspec + " in the keypool");
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, cd.encMeta);
        if (cd.encAlg == 1) {
            key = this.aes128key;
        } else if (cd.encAlg == 2) {
            key = this.aes192key;
        } else if (cd.encAlg == 3) {
            key = this.aes256key;
        } else {
            throw new XiSecurityException("unknown encryption algorithm " + cd.encAlg);
        }
        try {
            this.cipher.init(2, (Key)key, spec);
            plain = this.cipher.doFinal(cd.cipherText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new XiSecurityException("error decrypting ciphertext", (Throwable)ex);
        }
        return PrivateKeyInfo.getInstance((Object)plain);
    }

    public boolean isHealthy() {
        return this.queryExecutor != null && this.queryExecutor.isHealthy();
    }

    public void close() throws IOException {
    }

    private static class KeypoolQueryExecutor {
        private static final Logger LOG = LoggerFactory.getLogger(KeypoolQueryExecutor.class);
        private final DataSourceWrapper datasource;
        private final String sqlGetKeyData;

        KeypoolQueryExecutor(DataSourceWrapper datasource, int shardId) {
            this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
            this.sqlGetKeyData = datasource.buildSelectFirstSql(1, "ID,ENC_ALG,ENC_META,DATA FROM KEYPOOL WHERE SHARD_ID=" + shardId + " AND KID=?");
        }

        Map<String, Integer> getKeyspecs() throws DataAccessException {
            String sql = "SELECT ID,KEYSPEC FROM KEYSPEC";
            PreparedStatement ps = this.datasource.prepareStatement("SELECT ID,KEYSPEC FROM KEYSPEC");
            ResultSet rs = null;
            HashMap<String, Integer> rv = new HashMap<String, Integer>();
            try {
                rs = ps.executeQuery();
                while (rs.next()) {
                    rv.put(rs.getString("KEYSPEC").toUpperCase(Locale.ROOT), rs.getInt("ID"));
                }
                HashMap<String, Integer> hashMap = rv;
                return hashMap;
            }
            catch (SQLException ex) {
                throw this.datasource.translate("SELECT ID,KEYSPEC FROM KEYSPEC", ex);
            }
            finally {
                this.datasource.releaseResources((Statement)ps, rs);
            }
        }

        CipherData nextKeyData(int keyspecId) throws DataAccessException {
            String sql = this.sqlGetKeyData;
            PreparedStatement ps = this.datasource.prepareStatement(sql);
            ResultSet rs = null;
            try {
                ps.setInt(1, keyspecId);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    CipherData cipherData = null;
                    return cipherData;
                }
                int id = rs.getInt("ID");
                CipherData cd = new CipherData();
                cd.encAlg = rs.getInt("ENC_ALG");
                cd.encMeta = Base64.decodeFast((String)rs.getString("ENC_META"));
                cd.cipherText = Base64.decodeFast((String)rs.getString("DATA"));
                this.datasource.releaseResources((Statement)ps, rs);
                ps = null;
                rs = null;
                String sqlDeleteKeyData = "DELETE FROM KEYPOOL WHERE ID=?";
                ps = this.datasource.prepareStatement("DELETE FROM KEYPOOL WHERE ID=?");
                ps.setInt(1, id);
                ps.executeUpdate();
                CipherData cipherData = cd;
                return cipherData;
            }
            catch (SQLException ex) {
                throw this.datasource.translate(sql, ex);
            }
            finally {
                this.datasource.releaseResources((Statement)ps, rs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isHealthy() {
            String sql = "SELECT ID FROM KEYSPEC";
            try {
                ResultSet rs = null;
                PreparedStatement ps = this.datasource.prepareStatement("SELECT ID FROM KEYSPEC");
                try {
                    rs = ps.executeQuery();
                }
                finally {
                    this.datasource.releaseResources((Statement)ps, rs);
                }
                return true;
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                return false;
            }
        }
    }

    private static class CipherData {
        int encAlg;
        byte[] encMeta;
        byte[] cipherText;

        private CipherData() {
        }
    }
}

