/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertprofileValidator;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.sdk.CertprofileInfoResponse;
import org.xipki.ca.sdk.KeyType;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.TripleState;
import org.xipki.util.exception.ObjectCreationException;

class CertprofileManager {
    private static final Logger LOG = LoggerFactory.getLogger(CertprofileManager.class);
    private boolean certprofilesInitialized;
    private final CaManagerImpl manager;

    CertprofileManager(CaManagerImpl manager) {
        this.manager = (CaManagerImpl)Args.notNull((Object)manager, (String)"manager");
    }

    void reset() {
        this.certprofilesInitialized = false;
    }

    void close() {
        for (String name : this.manager.certprofiles.keySet()) {
            IdentifiedCertprofile certprofile = this.manager.certprofiles.get(name);
            this.shutdownCertprofile(certprofile);
        }
    }

    void initCertprofiles() throws CaMgmtException {
        if (this.certprofilesInitialized) {
            return;
        }
        for (String name : this.manager.certprofiles.keySet()) {
            this.shutdownCertprofile(this.manager.certprofiles.get(name));
        }
        this.manager.certprofileDbEntries.clear();
        this.manager.idNameMap.clearCertprofile();
        this.manager.certprofiles.clear();
        List<String> names = this.manager.caConfStore.getProfileNames();
        for (String name : names) {
            CertprofileEntry dbEntry = this.manager.caConfStore.createCertprofile(name);
            this.manager.idNameMap.addCertprofile(dbEntry.getIdent());
            dbEntry.setFaulty(true);
            this.manager.certprofileDbEntries.put(name, dbEntry);
            try {
                IdentifiedCertprofile profile = this.createCertprofile(dbEntry);
                dbEntry.setFaulty(false);
                this.manager.certprofiles.put(name, profile);
                LOG.info("loaded certprofile {}", (Object)name);
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("ERROR loading certprofile " + name));
            }
        }
        this.certprofilesInitialized = true;
    }

    void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Set<CaProfileEntry> set;
        this.manager.assertMasterMode();
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.manager.caConfStore.removeCertprofileFromCa(profileName, caName);
        if (this.manager.caHasProfiles.containsKey(caName) && (set = this.manager.caHasProfiles.get(caName)) != null) {
            CaProfileEntry profileEntry = null;
            for (CaProfileEntry entry : set) {
                if (!entry.getProfileName().equals(profileName)) continue;
                profileEntry = entry;
            }
            if (profileEntry != null) {
                set.remove(profileEntry);
            }
        }
    }

    void addCertprofileToCa(String profileNameAndAlias, String caName) throws CaMgmtException {
        CaProfileEntry caProfileEntry;
        this.manager.assertMasterMode();
        try {
            caProfileEntry = CaProfileEntry.decode((String)profileNameAndAlias);
        }
        catch (Exception ex) {
            throw new CaMgmtException("invalid syntax of profileNameAndAlias '" + profileNameAndAlias + "'", (Throwable)ex);
        }
        String profileName = caProfileEntry.getProfileName();
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        NameId ident = this.manager.idNameMap.getCertprofile(profileName);
        if (ident == null) {
            throw this.manager.logAndCreateException("unknown Certprofile " + profileName);
        }
        NameId caIdent = this.manager.idNameMap.getCa(caName);
        if (caIdent == null) {
            throw this.manager.logAndCreateException("unknown CA " + caName);
        }
        Set<CaProfileEntry> set = this.manager.caHasProfiles.get(caName);
        if (set == null) {
            set = new HashSet<CaProfileEntry>();
            this.manager.caHasProfiles.put(caName, set);
        } else {
            for (CaProfileEntry existingEntry : set) {
                String containedNameOrAlias = existingEntry.containedNameOrAlias(caProfileEntry);
                if (containedNameOrAlias == null) continue;
                throw this.manager.logAndCreateException("Certprofile (name or alias) '" + containedNameOrAlias + "' already associated with CA " + caName);
            }
        }
        this.manager.caConfStore.addCertprofileToCa(ident, caIdent, caProfileEntry.getProfileAliases());
        set.add(caProfileEntry);
    }

    void removeCertprofile(String name) throws CaMgmtException {
        this.manager.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        block0: for (String caName : this.manager.caHasProfiles.keySet()) {
            Set<CaProfileEntry> caHasProfiles = this.manager.caHasProfiles.get(caName);
            for (CaProfileEntry m : caHasProfiles) {
                if (!m.getProfileName().equals(name)) continue;
                this.removeCertprofileFromCa(name, caName);
                continue block0;
            }
        }
        boolean bo = this.manager.caConfStore.deleteProfile(name);
        if (!bo) {
            throw new CaMgmtException("unknown profile " + name);
        }
        LOG.info("removed profile '{}'", (Object)name);
        this.manager.idNameMap.removeCertprofile(this.manager.certprofileDbEntries.get(name).getIdent().getId());
        this.manager.certprofileDbEntries.remove(name);
        IdentifiedCertprofile profile = this.manager.certprofiles.remove(name);
        this.shutdownCertprofile(profile);
    }

    void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        this.manager.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        if (type == null && conf == null) {
            throw new IllegalArgumentException("type and conf cannot be both null");
        }
        NameId ident = this.manager.idNameMap.getCertprofile(name);
        if (ident == null) {
            throw this.manager.logAndCreateException("unknown Certprofile " + name);
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        IdentifiedCertprofile profile = this.manager.caConfStore.changeCertprofile(ident, type, conf, this.manager);
        this.manager.certprofileDbEntries.remove(name);
        IdentifiedCertprofile oldProfile = this.manager.certprofiles.remove(name);
        this.manager.certprofileDbEntries.put(name, profile.getDbEntry());
        this.manager.certprofiles.put(name, profile);
        if (oldProfile != null) {
            this.shutdownCertprofile(oldProfile);
        }
    }

    void addCertprofile(CertprofileEntry certprofileEntry) throws CaMgmtException {
        this.manager.assertMasterMode();
        String name = ((CertprofileEntry)Args.notNull((Object)certprofileEntry, (String)"certprofileEntry")).getIdent().getName();
        CaManagerImpl.checkName(name, "certprofile name");
        if (this.manager.certprofileDbEntries.containsKey(name)) {
            throw new CaMgmtException("Certprofile '" + name + "' exists");
        }
        certprofileEntry.setFaulty(true);
        IdentifiedCertprofile profile = Optional.ofNullable(this.createCertprofile(certprofileEntry)).orElseThrow(() -> new CaMgmtException("could not create Certprofile object"));
        certprofileEntry.setFaulty(false);
        this.manager.certprofiles.put(name, profile);
        this.manager.caConfStore.addCertprofile(certprofileEntry);
        this.manager.idNameMap.addCertprofile(certprofileEntry.getIdent());
        this.manager.certprofileDbEntries.put(name, certprofileEntry);
    }

    CertprofileInfoResponse getCertprofileInfo(String profileName) throws OperationException {
        IdentifiedCertprofile profile0 = Optional.ofNullable(this.manager.getIdentifiedCertprofile(profileName)).orElseThrow(() -> new OperationException(ErrorCode.UNKNOWN_CERT_PROFILE));
        Certprofile profile = profile0.getCertprofile();
        Map extnControls = profile.getExtensionControls();
        LinkedList<String> requiredExtensionsInReq = new LinkedList<String>();
        LinkedList<String> optionalExtensionsInReq = new LinkedList<String>();
        for (Map.Entry m : extnControls.entrySet()) {
            TripleState inRequest = ((Certprofile.ExtensionControl)m.getValue()).getInRequest();
            if (inRequest == null || inRequest == TripleState.forbidden) continue;
            if (((Certprofile.ExtensionControl)m.getValue()).isRequired() && inRequest == TripleState.required) {
                requiredExtensionsInReq.add(((ASN1ObjectIdentifier)m.getKey()).getId());
                continue;
            }
            optionalExtensionsInReq.add(((ASN1ObjectIdentifier)m.getKey()).getId());
        }
        String[] requiredOids = null;
        if (!requiredExtensionsInReq.isEmpty()) {
            requiredOids = requiredExtensionsInReq.toArray(new String[0]);
        }
        String[] optionalOids = null;
        if (!optionalExtensionsInReq.isEmpty()) {
            optionalOids = optionalExtensionsInReq.toArray(new String[0]);
        }
        KeyType[] keyTypes = null;
        Map keyAlgorithms = profile.getKeyAlgorithms();
        if (keyAlgorithms != null) {
            LinkedList<KeyType> keyTypeList = new LinkedList<KeyType>();
            for (Map.Entry m : keyAlgorithms.entrySet()) {
                Set curveOids;
                KeyParametersOption params = (KeyParametersOption)m.getValue();
                String[] ecCurves = null;
                if (params instanceof KeyParametersOption.ECParamatersOption && CollectionUtil.isNotEmpty((Collection)(curveOids = ((KeyParametersOption.ECParamatersOption)params).getCurveOids()))) {
                    LinkedList<String> curveOidsInText = new LinkedList<String>();
                    for (ASN1ObjectIdentifier curveOid : curveOids) {
                        curveOidsInText.add(curveOid.getId());
                    }
                    ecCurves = curveOidsInText.toArray(new String[0]);
                }
                keyTypeList.add(new KeyType(((ASN1ObjectIdentifier)m.getKey()).getId(), ecCurves));
            }
            if (!keyTypeList.isEmpty()) {
                keyTypes = keyTypeList.toArray(new KeyType[0]);
            }
        }
        return new CertprofileInfoResponse(requiredOids, optionalOids, keyTypes);
    }

    void shutdownCertprofile(IdentifiedCertprofile profile) {
        if (profile == null) {
            return;
        }
        try {
            profile.close();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not shutdown Certprofile " + profile.getIdent()));
        }
    }

    IdentifiedCertprofile createCertprofile(CertprofileEntry entry) throws CaMgmtException {
        String type = ((CertprofileEntry)Args.notNull((Object)entry, (String)"entry")).getType();
        if (!this.manager.certprofileFactoryRegister.canCreateProfile(type)) {
            throw new CaMgmtException("unsupported cert profile type " + type);
        }
        try {
            Certprofile profile = this.manager.certprofileFactoryRegister.newCertprofile(type);
            IdentifiedCertprofile identifiedCertprofile = new IdentifiedCertprofile(entry, profile);
            try {
                CertprofileValidator.validate((Certprofile)profile);
            }
            catch (CertprofileException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("validating certprofile " + entry.getIdent().getName() + " failed"));
            }
            return identifiedCertprofile;
        }
        catch (CertprofileException | ObjectCreationException ex) {
            String msg = "could not initialize Certprofile " + entry.getIdent();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new CaMgmtException(msg, ex);
        }
    }
}

