/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.publisher;

import java.security.NoSuchAlgorithmException;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.DataSourceMap;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherException;
import org.xipki.ca.server.publisher.OcspStoreQueryExecutor;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;

public class OcspCertPublisher
extends CertPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertPublisher.class);
    private OcspStoreQueryExecutor queryExecutor;
    private boolean publishsGoodCert = true;

    public void initialize(String conf, DataSourceMap datasourceConfs) throws CertPublisherException {
        Args.notNull((Object)conf, (String)"conf");
        ConfPairs pairs = new ConfPairs(conf);
        String str = pairs.value("publish.goodcerts");
        this.publishsGoodCert = str == null || Boolean.parseBoolean(str);
        ConfPairs confPairs = new ConfPairs(conf);
        String datasourceName = confPairs.value("datasource");
        DataSourceWrapper datasource = null;
        if (datasourceName != null) {
            datasource = datasourceConfs.getDataSource(datasourceName);
        }
        if (datasource == null) {
            throw new CertPublisherException("no datasource named '" + datasourceName + "' is specified");
        }
        try {
            this.queryExecutor = new OcspStoreQueryExecutor(datasource, this.publishsGoodCert);
        }
        catch (NoSuchAlgorithmException | DataAccessException ex) {
            throw new CertPublisherException(ex.getMessage(), ex);
        }
    }

    public boolean caAdded(X509Cert issuer) {
        try {
            this.queryExecutor.addIssuer(issuer);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(issuer.getSubjectText(), issuer, null, ex, "could not publish issuer");
            return false;
        }
    }

    public boolean certificateAdded(CertificateInfo certInfo) {
        X509Cert caCert = certInfo.getIssuerCert();
        CertWithDbId cert = certInfo.getCert();
        try {
            this.queryExecutor.addCert(caCert, cert, certInfo.getRevocationInfo());
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getSubjectText(), cert.getCert(), cert.getCertId(), ex, "could not save certificate");
            return false;
        }
    }

    public boolean certificateRevoked(X509Cert caCert, CertWithDbId cert, String certprofile, CertRevocationInfo revInfo) {
        try {
            this.queryExecutor.revokeCert(caCert, cert, revInfo);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getSubjectText(), cert.getCert(), cert.getCertId(), ex, "could not publish revoked certificate");
            return false;
        }
    }

    public boolean certificateUnrevoked(X509Cert caCert, CertWithDbId cert) {
        try {
            this.queryExecutor.unrevokeCert(caCert, cert);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getSubjectText(), cert.getCert(), cert.getCertId(), ex, "could not publish unrevocation of certificate");
            return false;
        }
    }

    private void logAndAudit(String issuer, X509Cert cert, Long certId, Exception ex, String messagePrefix) {
        String subjectText = cert.getSubjectText();
        String serialText = cert.getSerialNumberHex();
        LOG.error("{} (issuser='{}': subject='{}', serialNumber={}). Message: {}", new Object[]{messagePrefix, issuer, subjectText, serialText, ex.getMessage()});
        LOG.debug("error", (Throwable)ex);
        AuditEvent event = new AuditEvent("CAPublisher");
        event.setLevel(AuditLevel.ERROR);
        event.setStatus(AuditStatus.FAILED);
        if (certId != null) {
            event.addEventData("id", (Object)certId);
        }
        event.addEventData("issuer", (Object)issuer);
        event.addEventData("subject", (Object)subjectText);
        event.addEventData("serial", (Object)serialText);
        event.addEventData("message", (Object)messagePrefix);
        Audits.getAuditService().logEvent(event);
    }

    public boolean crlAdded(X509Cert caCert, X509CRLHolder crl) {
        return true;
    }

    public boolean isHealthy() {
        return this.queryExecutor.isHealthy();
    }

    public boolean caRevoked(X509Cert caCert, CertRevocationInfo revInfo) {
        try {
            this.queryExecutor.revokeCa(caCert, revInfo);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getIssuerText(), caCert, null, ex, "could not publish revocation of CA");
            return false;
        }
    }

    public boolean caUnrevoked(X509Cert caCert) {
        try {
            this.queryExecutor.unrevokeCa(caCert);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getIssuerText(), caCert, null, ex, "could not publish unrevocation of CA");
            return false;
        }
    }

    public boolean certificateRemoved(X509Cert issuerCert, CertWithDbId cert) {
        try {
            this.queryExecutor.removeCert(issuerCert, cert);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(issuerCert.getIssuerText(), issuerCert, null, ex, "could not publish removal of certificate");
            return false;
        }
    }

    public boolean publishsGoodCert() {
        return this.publishsGoodCert;
    }
}

