/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Info;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.MutexHandler;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import sun.security.pkcs11.wrapper.CK_CREATEMUTEX;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_DESTROYMUTEX;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_LOCKMUTEX;
import sun.security.pkcs11.wrapper.CK_UNLOCKMUTEX;
import sun.security.pkcs11.wrapper.PKCS11;

public class Module {
    private PKCS11 pkcs11Module;
    private String pkcs11ModuleName;

    public Module(String pkcs11ModuleName) {
        this.pkcs11ModuleName = pkcs11ModuleName;
    }

    public static Module getInstance(String pkcs11ModuleName) throws IOException {
        Util.requireNonNull("pkcs11ModuleName", pkcs11ModuleName);
        File file = new File(pkcs11ModuleName);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + pkcs11ModuleName + " does not exist");
        }
        if (!file.isFile()) {
            throw new IOException(pkcs11ModuleName + " is not a file");
        }
        if (!file.canRead()) {
            throw new IOException("Can not read file " + pkcs11ModuleName + "");
        }
        return new Module(pkcs11ModuleName);
    }

    public Info getInfo() throws TokenException {
        CK_INFO ckInfo;
        try {
            ckInfo = this.pkcs11Module.C_GetInfo();
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return new Info(ckInfo);
    }

    public void initialize(InitializeArgs initArgs) throws TokenException {
        CK_C_INITIALIZE_ARGS wrapperInitArgs = null;
        if (initArgs != null) {
            InitializeArgs castedInitArgs = initArgs;
            final MutexHandler mutexHandler = castedInitArgs.getMutexHandler();
            wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
            if (mutexHandler != null) {
                wrapperInitArgs.CreateMutex = new CK_CREATEMUTEX(){

                    @Override
                    public Object CK_CREATEMUTEX() throws sun.security.pkcs11.wrapper.PKCS11Exception {
                        return mutexHandler.createMutex();
                    }
                };
                wrapperInitArgs.DestroyMutex = new CK_DESTROYMUTEX(){

                    @Override
                    public void CK_DESTROYMUTEX(Object pMutex) throws sun.security.pkcs11.wrapper.PKCS11Exception {
                        mutexHandler.destroyMutex(pMutex);
                    }
                };
                wrapperInitArgs.LockMutex = new CK_LOCKMUTEX(){

                    @Override
                    public void CK_LOCKMUTEX(Object pMutex) throws sun.security.pkcs11.wrapper.PKCS11Exception {
                        mutexHandler.lockMutex(pMutex);
                    }
                };
                wrapperInitArgs.UnlockMutex = new CK_UNLOCKMUTEX(){

                    @Override
                    public void CK_UNLOCKMUTEX(Object pMutex) throws sun.security.pkcs11.wrapper.PKCS11Exception {
                        mutexHandler.unlockMutex(pMutex);
                    }
                };
            } else {
                wrapperInitArgs.CreateMutex = null;
                wrapperInitArgs.DestroyMutex = null;
                wrapperInitArgs.LockMutex = null;
                wrapperInitArgs.UnlockMutex = null;
            }
            if (castedInitArgs.isLibraryCantCreateOsThreads()) {
                wrapperInitArgs.flags |= 1L;
            }
            if (castedInitArgs.isOsLockingOk()) {
                wrapperInitArgs.flags |= 2L;
            }
            wrapperInitArgs.pReserved = castedInitArgs.getReserved();
        }
        String functionList = "C_GetFunctionList";
        boolean omitInitialize = false;
        try {
            this.pkcs11Module = PKCS11.getInstance(this.pkcs11ModuleName, "C_GetFunctionList", wrapperInitArgs, false);
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), ex);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public Slot[] getSlotList(boolean tokenPresent) throws TokenException {
        long[] slotIDs;
        try {
            slotIDs = this.pkcs11Module.C_GetSlotList(tokenPresent);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        Slot[] slots = new Slot[slotIDs.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = new Slot(this, slotIDs[i]);
        }
        return slots;
    }

    public PKCS11 getPKCS11Module() {
        return this.pkcs11Module;
    }

    public String toString() {
        return this.pkcs11Module != null ? this.pkcs11Module.toString() : null;
    }

    public void finalize() throws Throwable {
        Method method = PKCS11.class.getDeclaredMethod("finalize", new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)this.pkcs11Module, new Object[0]);
        super.finalize();
    }

    public void finalize(Object args) throws TokenException {
        try {
            this.pkcs11Module.C_Finalize(args);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Module)) {
            return false;
        }
        Module other = (Module)otherObject;
        return Util.objEquals(this.pkcs11Module, other.pkcs11Module);
    }

    public int hashCode() {
        return this.pkcs11Module.hashCode();
    }

    public static interface WaitingBehavior {
        public static final boolean BLOCK = false;
        public static final boolean DONT_BLOCK = true;
    }

    public static interface SlotRequirement {
        public static final boolean ALL_SLOTS = false;
        public static final boolean TOKEN_PRESENT = true;
    }
}

