/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.params.Params;
import iaik.pkcs.pkcs11.params.SSL3KeyMaterialParams;
import iaik.pkcs.pkcs11.params.SSL3MasterKeyDeriveParams;
import iaik.pkcs.pkcs11.params.VersionParams;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.Vector;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.PKCS11;

public class Session {
    private Module module;
    private PKCS11 pkcs11Module;
    private long sessionHandle;
    private Token token;

    protected Session(Token token, long sessionHandle) {
        this.token = Util.requireNonNull("token", token);
        this.module = token.getSlot().getModule();
        this.pkcs11Module = this.module.getPKCS11Module();
        this.sessionHandle = sessionHandle;
    }

    public void closeSession() throws TokenException {
        try {
            this.pkcs11Module.C_CloseSession(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Session)) {
            return false;
        }
        Session other = (Session)otherObject;
        if (this.sessionHandle != other.sessionHandle) {
            return false;
        }
        return this.token.equals(other.token);
    }

    public int hashCode() {
        return (int)this.sessionHandle;
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public SessionInfo getSessionInfo() throws TokenException {
        CK_SESSION_INFO ckSessionInfo;
        try {
            ckSessionInfo = this.pkcs11Module.C_GetSessionInfo(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return new SessionInfo(ckSessionInfo);
    }

    public Module getModule() {
        return this.module;
    }

    public Token getToken() {
        return this.token;
    }

    public byte[] getOperationState() throws TokenException {
        try {
            return this.pkcs11Module.C_GetOperationState(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void setOperationState(byte[] operationState, Key encryptionKey, Key authenticationKey) throws TokenException {
        try {
            this.pkcs11Module.C_SetOperationState(this.sessionHandle, operationState, encryptionKey.getObjectHandle(), authenticationKey.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void setSessionHandle(long sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public void login(boolean userType, char[] pin) throws TokenException {
        long tmpUserType = !userType ? 0L : 1L;
        try {
            this.pkcs11Module.C_Login(this.sessionHandle, tmpUserType, pin);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void login(long userType, char[] pin) throws TokenException {
        try {
            this.pkcs11Module.C_Login(this.sessionHandle, userType, pin);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void logout() throws TokenException {
        try {
            this.pkcs11Module.C_Logout(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object createObject(PKCS11Object templateObject) throws TokenException {
        long objectHandle;
        CK_ATTRIBUTE[] ckAttributes = PKCS11Object.getSetAttributes(templateObject);
        try {
            objectHandle = this.pkcs11Module.C_CreateObject(this.sessionHandle, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return PKCS11Object.getInstance(this, objectHandle);
    }

    public PKCS11Object copyObject(PKCS11Object sourceObject, PKCS11Object templateObject) throws TokenException {
        long newObjectHandle;
        long sourceObjectHandle = sourceObject.getObjectHandle();
        CK_ATTRIBUTE[] ckAttributes = PKCS11Object.getSetAttributes(templateObject);
        try {
            newObjectHandle = this.pkcs11Module.C_CopyObject(this.sessionHandle, sourceObjectHandle, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return PKCS11Object.getInstance(this, newObjectHandle);
    }

    public void setAttributeValues(PKCS11Object objectToUpdate, PKCS11Object templateObject) throws TokenException {
        long objectToUpdateHandle = objectToUpdate.getObjectHandle();
        CK_ATTRIBUTE[] ckAttributesTemplates = PKCS11Object.getSetAttributes(templateObject);
        try {
            this.pkcs11Module.C_SetAttributeValue(this.sessionHandle, objectToUpdateHandle, ckAttributesTemplates);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object getAttributeValues(PKCS11Object objectToRead) throws TokenException {
        long objectHandle = objectToRead.getObjectHandle();
        return PKCS11Object.getInstance(this, objectHandle);
    }

    public void destroyObject(PKCS11Object object) throws TokenException {
        long objectHandle = object.getObjectHandle();
        try {
            this.pkcs11Module.C_DestroyObject(this.sessionHandle, objectHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void findObjectsInit(PKCS11Object templateObject) throws TokenException {
        CK_ATTRIBUTE[] ckAttributes = PKCS11Object.getSetAttributes(templateObject);
        try {
            this.pkcs11Module.C_FindObjectsInit(this.sessionHandle, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object[] findObjects(int maxObjectCount) throws TokenException {
        long[] objectHandles;
        Vector<PKCS11Object> foundObjects = new Vector<PKCS11Object>();
        try {
            objectHandles = this.pkcs11Module.C_FindObjects(this.sessionHandle, maxObjectCount);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        try {
            for (int i = 0; i < objectHandles.length; ++i) {
                PKCS11Object object = PKCS11Object.getInstance(this, objectHandles[i]);
                foundObjects.addElement(object);
            }
            Object[] objectArray = new PKCS11Object[foundObjects.size()];
            foundObjects.copyInto(objectArray);
            return objectArray;
        }
        catch (TokenException e) {
            throw new TokenException(e);
        }
    }

    public void findObjectsFinal() throws TokenException {
        try {
            this.pkcs11Module.C_FindObjectsFinal(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void encryptInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_EncryptInit(this.sessionHandle, Session.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int encrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_Encrypt(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int encryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_EncryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int encryptFinal(byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_EncryptFinal(this.sessionHandle, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void decryptInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_DecryptInit(this.sessionHandle, Session.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int decrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_Decrypt(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int decryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_DecryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int decryptFinal(byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_DecryptFinal(this.sessionHandle, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void digestInit(Mechanism mechanism) throws TokenException {
        try {
            this.pkcs11Module.C_DigestInit(this.sessionHandle, Session.toCkMechanism(mechanism));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int digest(byte[] in, int inOfs, int inLen, byte[] digest, int digestOfs, int digestLen) throws TokenException {
        this.digestUpdate(in, inOfs, inLen);
        return this.digestFinal(digest, digestOfs, digestLen);
    }

    public int digestSingle(Mechanism mechanism, byte[] in, int inOfs, int inLen, byte[] digest, int digestOfs, int digestLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("digest", digest);
        try {
            return this.pkcs11Module.C_DigestSingle(this.sessionHandle, Session.toCkMechanism(mechanism), in, inOfs, inLen, digest, digestOfs, digestLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void digestUpdate(byte[] part, int partOfs, int partLen) throws TokenException {
        Util.requireNonNull("part", part);
        try {
            this.pkcs11Module.C_DigestUpdate(this.sessionHandle, 0L, part, partOfs, partLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void digestKey(SecretKey key) throws TokenException {
        try {
            this.pkcs11Module.C_DigestKey(this.sessionHandle, key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int digestFinal(byte[] digest, int digestOfs, int digestLen) throws TokenException {
        Util.requireNonNull("digest", digest);
        try {
            return this.pkcs11Module.C_DigestFinal(this.sessionHandle, digest, digestOfs, digestLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void signInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_SignInit(this.sessionHandle, Session.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public byte[] sign(byte[] data) throws TokenException {
        Util.requireNonNull("data", data);
        try {
            return this.pkcs11Module.C_Sign(this.sessionHandle, data);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void signUpdate(byte[] in, int inOfs, int inLen) throws TokenException {
        Util.requireNonNull("in", in);
        try {
            this.pkcs11Module.C_SignUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public byte[] signFinal(int expectedLen) throws TokenException {
        try {
            return this.pkcs11Module.C_SignFinal(this.sessionHandle, expectedLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void signRecoverInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_SignRecoverInit(this.sessionHandle, Session.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int signRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_SignRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_VerifyInit(this.sessionHandle, Session.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verify(byte[] data, byte[] signature) throws TokenException {
        Util.requireNonNull("signature", signature);
        try {
            this.pkcs11Module.C_Verify(this.sessionHandle, data, signature);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyUpdate(byte[] in, int inOfs, int inLen) throws TokenException {
        Util.requireNonNull("in", in);
        try {
            this.pkcs11Module.C_VerifyUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyFinal(byte[] signature) throws TokenException {
        Util.requireNonNull("signature", signature);
        try {
            this.pkcs11Module.C_VerifyFinal(this.sessionHandle, signature);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public void verifyRecoverInit(Mechanism mechanism, Key key) throws TokenException {
        try {
            this.pkcs11Module.C_VerifyRecoverInit(this.sessionHandle, Session.toCkMechanism(mechanism), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public int verifyRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        Util.requireNonNull("in", in);
        Util.requireNonNull("out", out);
        try {
            return this.pkcs11Module.C_VerifyRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public PKCS11Object generateKey(Mechanism mechanism, PKCS11Object template) throws TokenException {
        long objectHandle;
        CK_ATTRIBUTE[] ckAttributes = PKCS11Object.getSetAttributes(template);
        try {
            objectHandle = this.pkcs11Module.C_GenerateKey(this.sessionHandle, Session.toCkMechanism(mechanism), ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return PKCS11Object.getInstance(this, objectHandle);
    }

    public KeyPair generateKeyPair(Mechanism mechanism, PKCS11Object publicKeyTemplate, PKCS11Object privateKeyTemplate) throws TokenException {
        long[] objectHandles;
        CK_ATTRIBUTE[] ckPublicKeyAttributes = PKCS11Object.getSetAttributes(publicKeyTemplate);
        CK_ATTRIBUTE[] ckPrivateKeyAttributes = PKCS11Object.getSetAttributes(privateKeyTemplate);
        try {
            objectHandles = this.pkcs11Module.C_GenerateKeyPair(this.sessionHandle, Session.toCkMechanism(mechanism), ckPublicKeyAttributes, ckPrivateKeyAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        PublicKey publicKey = (PublicKey)PKCS11Object.getInstance(this, objectHandles[0]);
        PrivateKey privateKey = (PrivateKey)PKCS11Object.getInstance(this, objectHandles[1]);
        return new KeyPair(publicKey, privateKey);
    }

    public byte[] wrapKey(Mechanism mechanism, Key wrappingKey, Key key) throws TokenException {
        try {
            return this.pkcs11Module.C_WrapKey(this.sessionHandle, Session.toCkMechanism(mechanism), wrappingKey.getObjectHandle(), key.getObjectHandle());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public Key unwrapKey(Mechanism mechanism, Key unwrappingKey, byte[] wrappedKey, PKCS11Object keyTemplate) throws TokenException {
        long objectHandle;
        Util.requireNonNull("wrappedKey", wrappedKey);
        CK_ATTRIBUTE[] ckAttributes = PKCS11Object.getSetAttributes(keyTemplate);
        try {
            objectHandle = this.pkcs11Module.C_UnwrapKey(this.sessionHandle, Session.toCkMechanism(mechanism), unwrappingKey.getObjectHandle(), wrappedKey, ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return (Key)PKCS11Object.getInstance(this, objectHandle);
    }

    public Key deriveKey(Mechanism mechanism, Key baseKey, Key template) throws TokenException {
        long objectHandle;
        CK_MECHANISM ckMechanism = Session.toCkMechanism(mechanism);
        Params params = mechanism.getParams();
        CK_ATTRIBUTE[] ckAttributes = PKCS11Object.getSetAttributes(template);
        try {
            objectHandle = this.pkcs11Module.C_DeriveKey(this.sessionHandle, Session.toCkMechanism(mechanism), baseKey.getObjectHandle(), ckAttributes);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        if ((ckMechanism.mechanism == 881L || ckMechanism.mechanism == 885L) && params instanceof SSL3MasterKeyDeriveParams) {
            VersionParams version = ((SSL3MasterKeyDeriveParams)params).getVersion();
            version.setPKCS11ParamsObject(((CK_SSL3_MASTER_KEY_DERIVE_PARAMS)ckMechanism.pParameter).pVersion);
            return (Key)PKCS11Object.getInstance(this, objectHandle);
        }
        if ((ckMechanism.mechanism == 882L || ckMechanism.mechanism == 886L) && params instanceof SSL3KeyMaterialParams) {
            ((SSL3KeyMaterialParams)params).getReturnedKeyMaterial().setPKCS11ParamsObject(((CK_SSL3_KEY_MAT_PARAMS)ckMechanism.pParameter).pReturnedKeyMaterial, this);
            return null;
        }
        return (Key)PKCS11Object.getInstance(this, objectHandle);
    }

    public void seedRandom(byte[] seed) throws TokenException {
        try {
            this.pkcs11Module.C_SeedRandom(this.sessionHandle, seed);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws TokenException {
        byte[] randomBytesBuffer = new byte[numberOfBytesToGenerate];
        try {
            this.pkcs11Module.C_GenerateRandom(this.sessionHandle, randomBytesBuffer);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return randomBytesBuffer;
    }

    public String toString() {
        return Util.concatObjectsCap(100, "Session Handle: 0x", Long.toHexString(this.sessionHandle), "\nToken: ", this.token);
    }

    private static CK_MECHANISM toCkMechanism(Mechanism mechanism) {
        CK_MECHANISM ckMechanism = new CK_MECHANISM();
        ckMechanism.mechanism = mechanism.getMechanismCode();
        Params params = mechanism.getParams();
        ckMechanism.pParameter = params != null ? params.getPKCS11ParamsObject() : null;
        return ckMechanism;
    }

    public static interface UserType {
        public static final boolean SO = false;
        public static final boolean USER = true;
    }
}

