/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Util;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;

public class SessionInfo {
    protected long slotID;
    protected State state;
    protected long deviceError;
    protected long flags;

    protected SessionInfo(CK_SESSION_INFO ckSessionInfo) {
        Util.requireNonNull("ckSessionInfo", ckSessionInfo);
        this.slotID = ckSessionInfo.slotID;
        this.state = new State(ckSessionInfo.state);
        this.deviceError = ckSessionInfo.ulDeviceError;
        this.flags = ckSessionInfo.flags;
    }

    public State getState() {
        return this.state;
    }

    public long getDeviceError() {
        return this.deviceError;
    }

    public boolean isRwSession() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isSerialSession() {
        return (this.flags & 4L) != 0L;
    }

    public String toString() {
        return Util.concatObjectsCap(100, "State: ", this.state, "\nDevice Error: 0x", Long.toHexString(this.deviceError), "\nFlags: 0x", Util.toFullHex(this.flags), "\nRead/Write Session: ", this.isRwSession(), "\nSerial Session: ", this.isSerialSession());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SessionInfo)) {
            return false;
        }
        SessionInfo other = (SessionInfo)otherObject;
        return this.slotID == other.slotID && this.state.equals(other.state) && this.deviceError == other.deviceError && this.flags == other.flags;
    }

    public int hashCode() {
        return (int)this.slotID ^ this.state.hashCode() ^ (int)this.deviceError;
    }
}

