/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Version;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;

public class SlotInfo {
    private String slotDescription;
    private String manufacturerID;
    private Version hardwareVersion;
    private Version firmwareVersion;
    private long flags;

    protected SlotInfo(CK_SLOT_INFO ckSlotInfo) {
        Util.requireNonNull("ckSlotInfo", ckSlotInfo);
        this.slotDescription = new String(ckSlotInfo.slotDescription);
        this.manufacturerID = new String(ckSlotInfo.manufacturerID);
        this.hardwareVersion = new Version(ckSlotInfo.hardwareVersion);
        this.firmwareVersion = new Version(ckSlotInfo.firmwareVersion);
        this.flags = ckSlotInfo.flags;
    }

    public String getSlotDescription() {
        return this.slotDescription;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public Version getHardwareVersion() {
        return this.hardwareVersion;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean isTokenPresent() {
        return (this.flags & 1L) != 0L;
    }

    public boolean isRemovableDevice() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isHwSlot() {
        return (this.flags & 4L) != 0L;
    }

    public String toString() {
        return Util.concatObjectsCap(200, "Slot Description: ", this.slotDescription, "\nManufacturer ID: ", this.manufacturerID, "\nHardware Version: ", this.hardwareVersion, "\nFirmware Version: ", this.firmwareVersion, "\nFlags: 0X", Util.toFullHex(this.flags), "\nToken present: ", this.isTokenPresent(), "\nRemovable Device: ", this.isRemovableDevice(), "\nHardware Slot: ", this.isHwSlot());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SlotInfo)) {
            return false;
        }
        SlotInfo other = (SlotInfo)otherObject;
        return this.slotDescription.equals(other.slotDescription) && this.manufacturerID.equals(other.manufacturerID) && this.hardwareVersion.equals(other.hardwareVersion) && this.firmwareVersion.equals(other.firmwareVersion) && this.flags == other.flags;
    }

    public int hashCode() {
        return this.slotDescription.hashCode() ^ this.manufacturerID.hashCode() ^ this.hardwareVersion.hashCode() ^ this.firmwareVersion.hashCode();
    }
}

