/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CertificateTypeAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.WTLSCertificate;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Certificate
extends Storage {
    protected static VendorDefinedCertificateBuilder vendorCertificateBuilder;
    protected CertificateTypeAttribute certificateType;
    protected BooleanAttribute trusted;
    protected LongAttribute certificateCategory;
    protected ByteArrayAttribute checkValue;
    protected DateAttribute startDate;
    protected DateAttribute endDate;

    public Certificate() {
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.CERTIFICATE);
    }

    protected Certificate(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.CERTIFICATE);
    }

    public static String getCertificateTypeName(Long certificateType) {
        Util.requireNonNull("certificateType", certificateType);
        String certificateTypeName = certificateType.equals(CertificateType.X_509_PUBLIC_KEY) ? "X.509 Public Key" : (certificateType.equals(CertificateType.X_509_ATTRIBUTE) ? "X.509 Attribute" : ((certificateType & 0x80000000L) != 0L ? "Vendor Defined" : "<unknown>"));
        return certificateTypeName;
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        CertificateTypeAttribute certificateTypeAttribute = new CertificateTypeAttribute();
        Certificate.getAttributeValue(session, objectHandle, certificateTypeAttribute);
        Long certificateType = certificateTypeAttribute.getLongValue();
        PKCS11Object newObject = certificateTypeAttribute.isPresent() && certificateType != null ? (certificateType.equals(CertificateType.X_509_PUBLIC_KEY) ? X509PublicKeyCertificate.getInstance(session, objectHandle) : (certificateType.equals(CertificateType.X_509_ATTRIBUTE) ? X509AttributeCertificate.getInstance(session, objectHandle) : (certificateType.equals(CertificateType.WTLS) ? WTLSCertificate.getInstance(session, objectHandle) : ((certificateType & 0x80000000L) != 0L ? Certificate.getUnknownCertificate(session, objectHandle) : Certificate.getUnknownCertificate(session, objectHandle))))) : Certificate.getUnknownCertificate(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownCertificate(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (vendorCertificateBuilder != null) {
            try {
                newObject = vendorCertificateBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new Certificate(session, objectHandle);
            }
        } else {
            newObject = new Certificate(session, objectHandle);
        }
        return newObject;
    }

    public static void setVendorDefinedCertificateBuilder(VendorDefinedCertificateBuilder builder) {
        vendorCertificateBuilder = builder;
    }

    public static VendorDefinedCertificateBuilder getVendorDefinedCertificateBuilder() {
        return vendorCertificateBuilder;
    }

    protected static void putAttributesInTable(Certificate object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.CERTIFICATE_TYPE, object.certificateType);
        object.attributeTable.put(Attribute.TRUSTED, object.trusted);
        object.attributeTable.put(Attribute.CERTIFICATE_CATEGORY, object.certificateCategory);
        object.attributeTable.put(Attribute.CHECK_VALUE, object.checkValue);
        object.attributeTable.put(Attribute.START_DATE, object.startDate);
        object.attributeTable.put(Attribute.END_DATE, object.endDate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.certificateType = new CertificateTypeAttribute();
        this.trusted = new BooleanAttribute(Attribute.TRUSTED);
        this.certificateCategory = new LongAttribute(Attribute.CERTIFICATE_CATEGORY);
        this.checkValue = new ByteArrayAttribute(Attribute.CHECK_VALUE);
        this.startDate = new DateAttribute(Attribute.START_DATE);
        this.endDate = new DateAttribute(Attribute.END_DATE);
        Certificate.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)otherObject;
        return super.equals(other) && this.certificateType.equals(other.certificateType) && this.trusted.equals(other.trusted) && this.certificateCategory.equals(other.certificateCategory) && this.checkValue.equals(other.checkValue) && this.startDate.equals(other.startDate) && this.endDate.equals(other.endDate);
    }

    public LongAttribute getCertificateType() {
        return this.certificateType;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted;
    }

    public LongAttribute getCertificateCategory() {
        return this.certificateCategory;
    }

    public ByteArrayAttribute getCheckValue() {
        return this.checkValue;
    }

    public DateAttribute getStartDate() {
        return this.startDate;
    }

    public DateAttribute getEndDate() {
        return this.endDate;
    }

    @Override
    public int hashCode() {
        return this.certificateType.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.trusted, this.certificateCategory, this.checkValue, this.startDate, this.endDate});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\nCertificate Type: ", this.certificateType != null ? this.certificateType : "<unavailable>", "\nTrusted: ", this.trusted, "\nCertificate Category: ", this.certificateCategory, "\nCheck Value: ", this.checkValue, "\nStart Date: ", this.startDate, "\nEnd Date: ", this.endDate);
    }

    public static interface VendorDefinedCertificateBuilder {
        public PKCS11Object build(Session var1, long var2) throws PKCS11Exception;
    }

    public static interface CertificateType {
        public static final Long X_509_PUBLIC_KEY = new Long(0L);
        public static final Long X_509_ATTRIBUTE = new Long(1L);
        public static final Long WTLS = new Long(2L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }
}

