/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class DHParams
extends DomainParameters {
    protected ByteArrayAttribute prime;
    protected ByteArrayAttribute base;
    protected LongAttribute primeBits;

    public DHParams() {
        this.keyType.setLongValue(Key.KeyType.DH);
    }

    protected DHParams(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(Key.KeyType.DH);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new DHParams(session, objectHandle);
    }

    protected static void putAttributesInTable(DHParams object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.PRIME, object.prime);
        object.attributeTable.put(Attribute.BASE, object.base);
        object.attributeTable.put(Attribute.PRIME_BITS, object.primeBits);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime = new ByteArrayAttribute(Attribute.PRIME);
        this.base = new ByteArrayAttribute(Attribute.BASE);
        this.primeBits = new LongAttribute(Attribute.PRIME_BITS);
        DHParams.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof DHParams)) {
            return false;
        }
        DHParams other = (DHParams)otherObject;
        return super.equals(other) && this.prime.equals(other.prime) && this.base.equals(other.base) && this.primeBits.equals(other.primeBits);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime;
    }

    public ByteArrayAttribute getBase() {
        return this.base;
    }

    public LongAttribute getPrimeBits() {
        return this.primeBits;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.prime, this.base, this.primeBits});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Prime (hex): ", this.prime, "\n  Base (hex): ", this.base, "\n  Prime Bits (dec): ", this.primeBits.toString(10));
    }
}

