/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class DSAParams
extends DomainParameters {
    protected ByteArrayAttribute prime;
    protected ByteArrayAttribute subprime;
    protected ByteArrayAttribute base;
    protected LongAttribute primeBits;

    public DSAParams() {
        this.keyType.setLongValue(Key.KeyType.DSA);
    }

    protected DSAParams(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(Key.KeyType.DSA);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new DSAParams(session, objectHandle);
    }

    protected static void putAttributesInTable(DSAParams object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.PRIME, object.prime);
        object.attributeTable.put(Attribute.SUBPRIME, object.subprime);
        object.attributeTable.put(Attribute.BASE, object.base);
        object.attributeTable.put(Attribute.PRIME_BITS, object.primeBits);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime = new ByteArrayAttribute(Attribute.PRIME);
        this.subprime = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.base = new ByteArrayAttribute(Attribute.BASE);
        this.primeBits = new LongAttribute(Attribute.PRIME_BITS);
        DSAParams.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof DSAParams)) {
            return false;
        }
        DSAParams other = (DSAParams)otherObject;
        return super.equals(other) && this.prime.equals(other.prime) && this.subprime.equals(other.subprime) && this.base.equals(other.base) && this.primeBits.equals(other.primeBits);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime;
    }

    public ByteArrayAttribute getBase() {
        return this.base;
    }

    public LongAttribute getPrimeBits() {
        return this.primeBits;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.prime, this.subprime, this.base, this.primeBits});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Prime (hex): ", this.prime, "\n  Subprime (hex): ", this.subprime, "\n  Base (hex): ", this.base, "\n  Prime Bits (dec): ", this.primeBits.toString(10));
    }
}

