/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import java.util.Arrays;
import java.util.Date;
import sun.security.pkcs11.wrapper.CK_DATE;

public class DateAttribute
extends Attribute {
    public DateAttribute(Long type) {
        super(type);
    }

    public void setDateValue(Date value) {
        this.ckAttribute.pValue = Util.convertToCkDate(value);
        this.present = true;
    }

    public Date getDateValue() {
        return Util.convertToDate((CK_DATE)this.ckAttribute.pValue);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof DateAttribute)) {
            return false;
        }
        DateAttribute other = (DateAttribute)otherObject;
        if (!this.present && !other.present) {
            return true;
        }
        if (!this.present || !other.present) {
            return false;
        }
        if (this.sensitive != other.sensitive) {
            return false;
        }
        if (this.ckAttribute.type != other.ckAttribute.type) {
            return false;
        }
        return DateAttribute.equals((CK_DATE)this.ckAttribute.pValue, (CK_DATE)other.ckAttribute.pValue);
    }

    @Override
    public int hashCode() {
        if (this.ckAttribute.pValue == null) {
            return (int)this.ckAttribute.type;
        }
        return (int)this.ckAttribute.type ^ DateAttribute.hashCode((CK_DATE)this.ckAttribute.pValue);
    }

    @Override
    public void setValue(Object value) {
        this.setDateValue((Date)value);
    }

    private static boolean equals(CK_DATE date1, CK_DATE date2) {
        boolean equal = false;
        equal = date1 == date2 ? true : (date1 != null && date2 != null ? Arrays.equals(date1.year, date2.year) && Arrays.equals(date1.month, date2.month) && Arrays.equals(date1.day, date2.day) : false);
        return equal;
    }

    private static int hashCode(CK_DATE date) {
        int hash = 0;
        if (date != null) {
            if (date.year.length == 4) {
                hash ^= (0xFFFF & date.year[0]) << 16;
                hash ^= 0xFFFF & date.year[1];
                hash ^= (0xFFFF & date.year[2]) << 16;
                hash ^= 0xFFFF & date.year[3];
            }
            if (date.month.length == 2) {
                hash ^= (0xFFFF & date.month[0]) << 16;
                hash ^= 0xFFFF & date.month[1];
            }
            if (date.day.length == 2) {
                hash ^= (0xFFFF & date.day[0]) << 16;
                hash ^= 0xFFFF & date.day[1];
            }
        }
        return hash;
    }
}

