/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PublicKey;

public class ECPublicKey
extends PublicKey {
    protected ByteArrayAttribute ecdsaParams;
    protected ByteArrayAttribute ecPoint;

    public ECPublicKey() {
        this.keyType.setLongValue(this.thisKeyType());
    }

    protected ECPublicKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(this.thisKeyType());
    }

    protected Long thisKeyType() {
        return Key.KeyType.EC;
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new ECPublicKey(session, objectHandle);
    }

    protected static void putAttributesInTable(ECPublicKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.EC_PARAMS, object.ecdsaParams);
        object.attributeTable.put(Attribute.EC_POINT, object.ecPoint);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.ecdsaParams = new ByteArrayAttribute(Attribute.EC_PARAMS);
        this.ecPoint = new ByteArrayAttribute(Attribute.EC_POINT);
        ECPublicKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof ECPublicKey)) {
            return false;
        }
        ECPublicKey other = (ECPublicKey)otherObject;
        return super.equals(other) && this.ecdsaParams.equals(other.ecdsaParams) && this.ecPoint.equals(other.ecPoint);
    }

    public ByteArrayAttribute getEcdsaParams() {
        return this.ecdsaParams;
    }

    public ByteArrayAttribute getEcPoint() {
        return this.ecPoint;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.ecdsaParams, this.ecPoint});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  ECDSA Params (DER, hex): ", this.ecdsaParams, "\n  EC Point (DER, hex): ", this.ecPoint);
    }
}

