/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.constants.PKCS11Constants;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MechanismArrayAttribute;
import iaik.pkcs.pkcs11.objects.MechanismAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.Hashtable;

public class Key
extends Storage {
    protected static VendorDefinedKeyBuilder vendorKeyBuilder;
    protected static Hashtable<Long, String> keyTypeNames;
    protected KeyTypeAttribute keyType;
    protected ByteArrayAttribute id;
    protected DateAttribute startDate;
    protected DateAttribute endDate;
    protected BooleanAttribute derive;
    protected BooleanAttribute local;
    protected MechanismAttribute keyGenMechanism;
    protected MechanismArrayAttribute allowedMechanisms;

    public Key() {
    }

    protected Key(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
    }

    public static void setVendorDefinedKeyBuilder(VendorDefinedKeyBuilder builder) {
        vendorKeyBuilder = builder;
    }

    public static VendorDefinedKeyBuilder getVendorDefinedKeyBuilder() {
        return vendorKeyBuilder;
    }

    public static String getKeyTypeName(Long keyType) {
        String keyTypeName;
        Util.requireNonNull("keyType", keyType);
        if (keyTypeNames == null) {
            keyTypeNames = new Hashtable(24);
            keyTypeNames.put(KeyType.RSA, "RSA");
            keyTypeNames.put(KeyType.DSA, "DSA");
            keyTypeNames.put(KeyType.DH, "DH");
            keyTypeNames.put(KeyType.EC, "EC");
            keyTypeNames.put(KeyType.X9_42_DH, "X9_42_DH");
            keyTypeNames.put(KeyType.KEA, "KEA");
            keyTypeNames.put(KeyType.GENERIC_SECRET, "GENERIC_SECRET");
            keyTypeNames.put(KeyType.RC2, "RC2");
            keyTypeNames.put(KeyType.RC4, "RC4");
            keyTypeNames.put(KeyType.DES, "DES");
            keyTypeNames.put(KeyType.DES2, "DES2");
            keyTypeNames.put(KeyType.DES3, "DES3");
            keyTypeNames.put(KeyType.CAST, "CAST");
            keyTypeNames.put(KeyType.CAST3, "CAST3");
            keyTypeNames.put(KeyType.CAST128, "CAST128");
            keyTypeNames.put(KeyType.RC5, "RC5");
            keyTypeNames.put(KeyType.IDEA, "IDEA");
            keyTypeNames.put(KeyType.SKIPJACK, "SKIPJACK");
            keyTypeNames.put(KeyType.BATON, "BATON");
            keyTypeNames.put(KeyType.JUNIPER, "JUNIPER");
            keyTypeNames.put(KeyType.CDMF, "CDMF");
            keyTypeNames.put(KeyType.AES, "AES");
            keyTypeNames.put(KeyType.BLOWFISH, "BLOWFISH");
            keyTypeNames.put(KeyType.TWOFISH, "TWOFISH");
            keyTypeNames.put(KeyType.VENDOR_SM2, "SM2");
            keyTypeNames.put(KeyType.VENDOR_SM4, "SM4");
        }
        if ((keyTypeName = keyTypeNames.get(keyType)) == null) {
            keyTypeName = (keyType & 0x80000000L) != 0L ? "Vendor Defined" : "<unknown>";
        }
        return keyTypeName;
    }

    protected static void putAttributesInTable(Key object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.KEY_TYPE, object.keyType);
        object.attributeTable.put(Attribute.ID, object.id);
        object.attributeTable.put(Attribute.START_DATE, object.startDate);
        object.attributeTable.put(Attribute.END_DATE, object.endDate);
        object.attributeTable.put(Attribute.DERIVE, object.derive);
        object.attributeTable.put(Attribute.LOCAL, object.local);
        object.attributeTable.put(Attribute.KEY_GEN_MECHANISM, object.keyGenMechanism);
        object.attributeTable.put(Attribute.ALLOWED_MECHANISMS, object.allowedMechanisms);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.keyType = new KeyTypeAttribute();
        this.id = new ByteArrayAttribute(Attribute.ID);
        this.startDate = new DateAttribute(Attribute.START_DATE);
        this.endDate = new DateAttribute(Attribute.END_DATE);
        this.derive = new BooleanAttribute(Attribute.DERIVE);
        this.local = new BooleanAttribute(Attribute.LOCAL);
        this.keyGenMechanism = new MechanismAttribute(Attribute.KEY_GEN_MECHANISM);
        this.allowedMechanisms = new MechanismArrayAttribute(Attribute.ALLOWED_MECHANISMS);
        Key.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Key)) {
            return false;
        }
        Key other = (Key)otherObject;
        return super.equals(other) && this.keyType.equals(other.keyType) && this.id.equals(other.id) && this.startDate.equals(other.startDate) && this.endDate.equals(other.endDate) && this.derive.equals(other.derive) && this.local.equals(other.local) && this.keyGenMechanism.equals(other.keyGenMechanism) && this.allowedMechanisms.equals(other.allowedMechanisms);
    }

    public LongAttribute getKeyType() {
        return this.keyType;
    }

    public ByteArrayAttribute getId() {
        return this.id;
    }

    public DateAttribute getStartDate() {
        return this.startDate;
    }

    public DateAttribute getEndDate() {
        return this.endDate;
    }

    public BooleanAttribute getDerive() {
        return this.derive;
    }

    public BooleanAttribute getLocal() {
        return this.local;
    }

    public MechanismAttribute getKeyGenMechanism() {
        return this.keyGenMechanism;
    }

    public MechanismArrayAttribute getAllowedMechanisms() {
        return this.allowedMechanisms;
    }

    @Override
    public int hashCode() {
        return this.keyType.hashCode() ^ this.id.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.id, this.startDate, this.endDate, this.derive, this.local, this.keyGenMechanism});
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.allowedMechanisms);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Key Type: ", this.keyType != null ? this.keyType.toString() : "<unavailable>", "\n  ID: ", this.id, "\n  Start Date: ", this.startDate, "\n  End Date: ", this.endDate, "\n  Derive: ", this.derive, "\n  Local: ", this.local, "\n  Key Generation Mechanism: ", this.keyGenMechanism, "\n  Allowed Mechanisms: ", this.allowedMechanisms);
    }

    public static interface VendorDefinedKeyBuilder {
        public PKCS11Object build(Session var1, long var2) throws PKCS11Exception;
    }

    public static interface KeyType {
        public static final Long RSA = new Long(0L);
        public static final Long DSA = new Long(1L);
        public static final Long DH = new Long(2L);
        public static final Long EC = new Long(3L);
        public static final Long X9_42_DH = new Long(4L);
        public static final Long KEA = new Long(5L);
        public static final Long GENERIC_SECRET = new Long(16L);
        public static final Long RC2 = new Long(17L);
        public static final Long RC4 = new Long(18L);
        public static final Long DES = new Long(19L);
        public static final Long DES2 = new Long(20L);
        public static final Long DES3 = new Long(21L);
        public static final Long CAST = new Long(22L);
        public static final Long CAST3 = new Long(23L);
        public static final Long CAST128 = new Long(24L);
        public static final Long RC5 = new Long(25L);
        public static final Long IDEA = new Long(26L);
        public static final Long SKIPJACK = new Long(27L);
        public static final Long BATON = new Long(28L);
        public static final Long JUNIPER = new Long(29L);
        public static final Long CDMF = new Long(30L);
        public static final Long AES = new Long(31L);
        public static final Long BLOWFISH = new Long(32L);
        public static final Long TWOFISH = new Long(33L);
        public static final Long VENDOR_SM2 = new Long(PKCS11Constants.CKK_VENDOR_SM2);
        public static final Long VENDOR_SM4 = new Long(PKCS11Constants.CKK_VENDOR_SM4);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }
}

