/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class Mechanism
extends PKCS11Object {
    protected LongAttribute mechanismType;

    public Mechanism() {
    }

    protected Mechanism(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
    }

    protected static void putAttributesInTable(Mechanism object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.MECHANISM_TYPE, object.mechanismType);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.mechanismType = new LongAttribute(Attribute.MECHANISM_TYPE);
        Mechanism.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Mechanism)) {
            return false;
        }
        Mechanism other = (Mechanism)otherObject;
        return super.equals(other) && this.mechanismType.equals(other.mechanismType);
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.mechanismType);
    }

    public LongAttribute getMechanismType() {
        return this.mechanismType;
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 40, superToString, "\n  Mechanism Type: ", this.mechanismType);
    }

    @Override
    public int hashCode() {
        return this.mechanismType.hashCode();
    }
}

