/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECPublicKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.SM2PublicKey;
import iaik.pkcs.pkcs11.objects.X942DHPublicKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class PublicKey
extends Key {
    protected ByteArrayAttribute subject;
    protected BooleanAttribute encrypt;
    protected BooleanAttribute verify;
    protected BooleanAttribute verifyRecover;
    protected BooleanAttribute wrap;
    protected BooleanAttribute trusted;
    protected AttributeArray wrapTemplate;

    public PublicKey() {
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.PUBLIC_KEY);
    }

    protected PublicKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.PUBLIC_KEY);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        PublicKey.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        PKCS11Object newObject = keyTypeAttribute.isPresent() && keyType != null ? (keyType.equals(Key.KeyType.RSA) ? RSAPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DSA) ? DSAPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.EC) ? ECPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DH) ? DHPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.KEA) ? KEAPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.X9_42_DH) ? X942DHPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.VENDOR_SM2) ? SM2PublicKey.getInstance(session, objectHandle) : ((keyType & Key.KeyType.VENDOR_DEFINED) != 0L ? PublicKey.getUnknownPublicKey(session, objectHandle) : PublicKey.getUnknownPublicKey(session, objectHandle))))))))) : PublicKey.getUnknownPublicKey(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownPublicKey(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (Key.vendorKeyBuilder != null) {
            try {
                newObject = Key.vendorKeyBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new PublicKey(session, objectHandle);
            }
        } else {
            newObject = new PublicKey(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(PublicKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.SUBJECT, object.subject);
        object.attributeTable.put(Attribute.ENCRYPT, object.encrypt);
        object.attributeTable.put(Attribute.VERIFY, object.verify);
        object.attributeTable.put(Attribute.VERIFY_RECOVER, object.verifyRecover);
        object.attributeTable.put(Attribute.WRAP, object.wrap);
        object.attributeTable.put(Attribute.TRUSTED, object.trusted);
        object.attributeTable.put(Attribute.WRAP_TEMPLATE, object.wrapTemplate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject = new ByteArrayAttribute(Attribute.SUBJECT);
        this.encrypt = new BooleanAttribute(Attribute.ENCRYPT);
        this.verify = new BooleanAttribute(Attribute.VERIFY);
        this.verifyRecover = new BooleanAttribute(Attribute.VERIFY_RECOVER);
        this.wrap = new BooleanAttribute(Attribute.WRAP);
        this.trusted = new BooleanAttribute(Attribute.TRUSTED);
        this.wrapTemplate = new AttributeArray(Attribute.WRAP_TEMPLATE);
        PublicKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)otherObject;
        return super.equals(other) && this.subject.equals(other.subject) && this.encrypt.equals(other.encrypt) && this.verify.equals(other.verify) && this.verifyRecover.equals(other.verifyRecover) && this.wrap.equals(other.wrap) && this.trusted.equals(other.trusted) && this.wrapTemplate.equals(other.wrapTemplate);
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public BooleanAttribute getEncrypt() {
        return this.encrypt;
    }

    public BooleanAttribute getVerify() {
        return this.verify;
    }

    public BooleanAttribute getVerifyRecover() {
        return this.verifyRecover;
    }

    public BooleanAttribute getWrap() {
        return this.wrap;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted;
    }

    public AttributeArray getWrapTemplate() {
        return this.wrapTemplate;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.subject, this.encrypt, this.verify, this.verifyRecover, this.wrap, this.trusted});
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.wrapTemplate);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Subject (DER, hex): ", this.subject, "\n  Encrypt: ", this.encrypt, "\n  Verify: ", this.verify, "\n  Verify Recover: ", this.verifyRecover, "\n  Wrap: ", this.wrap, "\n  Trusted: ", this.trusted, "\n  Wrap Template: ", this.wrapTemplate);
    }
}

