/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class WTLSCertificate
extends Certificate {
    protected ByteArrayAttribute subject;
    protected ByteArrayAttribute issuer;
    protected ByteArrayAttribute value;
    protected CharArrayAttribute url;
    protected ByteArrayAttribute hashOfSubjectPublicKey;
    protected ByteArrayAttribute hashOfIssuerPublicKey;

    public WTLSCertificate() {
        this.certificateType.setLongValue(Certificate.CertificateType.WTLS);
    }

    protected WTLSCertificate(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.certificateType.setLongValue(Certificate.CertificateType.WTLS);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new WTLSCertificate(session, objectHandle);
    }

    protected static void putAttributesInTable(WTLSCertificate object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.SUBJECT, object.subject);
        object.attributeTable.put(Attribute.ISSUER, object.issuer);
        object.attributeTable.put(Attribute.VALUE, object.value);
        object.attributeTable.put(Attribute.URL, object.url);
        object.attributeTable.put(Attribute.HASH_OF_SUBJECT_PUBLIC_KEY, object.hashOfSubjectPublicKey);
        object.attributeTable.put(Attribute.HASH_OF_ISSUER_PUBLIC_KEY, object.hashOfIssuerPublicKey);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject = new ByteArrayAttribute(Attribute.SUBJECT);
        this.issuer = new ByteArrayAttribute(Attribute.ISSUER);
        this.value = new ByteArrayAttribute(Attribute.VALUE);
        this.url = new CharArrayAttribute(Attribute.URL);
        this.hashOfSubjectPublicKey = new ByteArrayAttribute(Attribute.HASH_OF_SUBJECT_PUBLIC_KEY);
        this.hashOfIssuerPublicKey = new ByteArrayAttribute(Attribute.HASH_OF_ISSUER_PUBLIC_KEY);
        WTLSCertificate.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof WTLSCertificate)) {
            return false;
        }
        WTLSCertificate other = (WTLSCertificate)otherObject;
        return super.equals(other) && this.subject.equals(other.subject) && this.issuer.equals(other.issuer) && this.value.equals(other.value) && this.url.equals(other.url) && this.hashOfSubjectPublicKey.equals(other.hashOfSubjectPublicKey) && this.hashOfIssuerPublicKey.equals(other.hashOfIssuerPublicKey);
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public ByteArrayAttribute getIssuer() {
        return this.issuer;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    public CharArrayAttribute getUrl() {
        return this.url;
    }

    public ByteArrayAttribute getHashOfSubjectPublicKey() {
        return this.hashOfSubjectPublicKey;
    }

    public ByteArrayAttribute getHashOfIssuerPublicKey() {
        return this.hashOfIssuerPublicKey;
    }

    @Override
    public int hashCode() {
        return this.issuer.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.subject, this.issuer, this.value});
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.url, this.hashOfSubjectPublicKey, this.hashOfIssuerPublicKey});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Subject (DER, hex): ", this.subject, "\n  Issuer (DER, hex): ", this.issuer, "\n  Value (BER, hex): ", this.value, "\n  URL: ", this.url, "\n  Hash(Subject Public Key): ", this.hashOfSubjectPublicKey, "\n  Hash(Issuer Public Key): ", this.hashOfIssuerPublicKey);
    }
}

