/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class X509PublicKeyCertificate
extends Certificate {
    protected ByteArrayAttribute subject;
    protected ByteArrayAttribute id;
    protected ByteArrayAttribute issuer;
    protected ByteArrayAttribute serialNumber;
    protected ByteArrayAttribute value;
    protected CharArrayAttribute url;
    protected ByteArrayAttribute hashOfSubjectPublicKey;
    protected ByteArrayAttribute hashOfIssuerPublicKey;
    protected LongAttribute javaMidpSecurityDomain;

    public X509PublicKeyCertificate() {
        this.certificateType.setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
    }

    protected X509PublicKeyCertificate(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.certificateType.setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X509PublicKeyCertificate(session, objectHandle);
    }

    protected static void putAttributesInTable(X509PublicKeyCertificate object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.SUBJECT, object.subject);
        object.attributeTable.put(Attribute.ID, object.id);
        object.attributeTable.put(Attribute.ISSUER, object.issuer);
        object.attributeTable.put(Attribute.SERIAL_NUMBER, object.serialNumber);
        object.attributeTable.put(Attribute.VALUE, object.value);
        object.attributeTable.put(Attribute.URL, object.url);
        object.attributeTable.put(Attribute.HASH_OF_SUBJECT_PUBLIC_KEY, object.hashOfSubjectPublicKey);
        object.attributeTable.put(Attribute.HASH_OF_ISSUER_PUBLIC_KEY, object.hashOfIssuerPublicKey);
        object.attributeTable.put(Attribute.JAVA_MIDP_SECURITY_DOMAIN, object.javaMidpSecurityDomain);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject = new ByteArrayAttribute(Attribute.SUBJECT);
        this.id = new ByteArrayAttribute(Attribute.ID);
        this.issuer = new ByteArrayAttribute(Attribute.ISSUER);
        this.serialNumber = new ByteArrayAttribute(Attribute.SERIAL_NUMBER);
        this.value = new ByteArrayAttribute(Attribute.VALUE);
        this.url = new CharArrayAttribute(Attribute.URL);
        this.hashOfSubjectPublicKey = new ByteArrayAttribute(Attribute.HASH_OF_SUBJECT_PUBLIC_KEY);
        this.hashOfIssuerPublicKey = new ByteArrayAttribute(Attribute.HASH_OF_ISSUER_PUBLIC_KEY);
        this.javaMidpSecurityDomain = new LongAttribute(Attribute.JAVA_MIDP_SECURITY_DOMAIN);
        X509PublicKeyCertificate.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X509PublicKeyCertificate)) {
            return false;
        }
        X509PublicKeyCertificate other = (X509PublicKeyCertificate)otherObject;
        return super.equals(other) && this.subject.equals(other.subject) && this.id.equals(other.id) && this.issuer.equals(other.issuer) && this.serialNumber.equals(other.serialNumber) && this.value.equals(other.value) && this.url.equals(other.url) && this.hashOfSubjectPublicKey.equals(other.hashOfSubjectPublicKey) && this.hashOfIssuerPublicKey.equals(other.hashOfIssuerPublicKey) && this.javaMidpSecurityDomain.equals(other.javaMidpSecurityDomain);
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public ByteArrayAttribute getId() {
        return this.id;
    }

    public ByteArrayAttribute getIssuer() {
        return this.issuer;
    }

    public ByteArrayAttribute getSerialNumber() {
        return this.serialNumber;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    public CharArrayAttribute getUrl() {
        return this.url;
    }

    public ByteArrayAttribute getHashOfSubjectPublicKey() {
        return this.hashOfSubjectPublicKey;
    }

    public ByteArrayAttribute getHashOfIssuerPublicKey() {
        return this.hashOfIssuerPublicKey;
    }

    public LongAttribute getJavaMidpSecurityDomain() {
        return this.javaMidpSecurityDomain;
    }

    @Override
    public int hashCode() {
        return this.issuer.hashCode() ^ this.serialNumber.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.subject, this.id, this.issuer, this.serialNumber, this.value});
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.url, this.hashOfSubjectPublicKey, this.hashOfIssuerPublicKey, this.javaMidpSecurityDomain});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 200, superToString, "\n  Subject (DER, hex): ", this.subject, "\n  ID (hex): ", this.id, "\n  Issuer (DER, hex): ", this.issuer, "\n  Serial Number (DER, hex): ", this.serialNumber, "\n  Value (BER, hex): ", this.value, "\n  URL: ", this.url, "\n  Hash Of Subject Public Key: ", this.hashOfSubjectPublicKey, "\n  Hash Of Issuer Public Key: ", this.hashOfIssuerPublicKey, "\n  Java MIDP Security Domain: ", this.javaMidpSecurityDomain);
    }
}

