/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.DHKeyDerivationParams;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;

public class EcDH1KeyDerivationParams
extends DHKeyDerivationParams {
    protected byte[] sharedData;

    public EcDH1KeyDerivationParams(long kdf, byte[] sharedData, byte[] publicData) {
        super(kdf, publicData);
        this.sharedData = sharedData;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        return new CK_ECDH1_DERIVE_PARAMS(this.kdf, this.sharedData, this.publicData);
    }

    public byte[] getSharedData() {
        return this.sharedData;
    }

    public void setSharedData(byte[] sharedData) {
        this.sharedData = sharedData;
    }

    @Override
    public String toString() {
        return Util.concat(super.toString(), "\n  Shared Data: ", Util.toHex(this.sharedData));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof EcDH1KeyDerivationParams)) {
            return false;
        }
        EcDH1KeyDerivationParams other = (EcDH1KeyDerivationParams)otherObject;
        return super.equals(other) && Arrays.equals(this.sharedData, other.sharedData);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Util.hashCode(this.sharedData);
    }
}

