/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.Params;

public abstract class RSAPkcsParams
implements Params {
    protected Mechanism hashAlg;
    protected long mgf;

    protected RSAPkcsParams(Mechanism hashAlg, long mgf) {
        if (mgf != 1L && mgf != 5L && mgf != 2L && mgf != 3L && mgf != 4L && mgf != 6L && mgf != 7L && mgf != 8L && mgf != 9L) {
            throw new IllegalArgumentException("Illegal value for argument\"mgf\": " + Long.toHexString(mgf));
        }
        this.hashAlg = Util.requireNonNull("hashAlg", hashAlg);
        this.mgf = mgf;
    }

    public Mechanism getHashAlgorithm() {
        return this.hashAlg;
    }

    public long getMaskGenerationFunction() {
        return this.mgf;
    }

    public void setHashAlgorithm(Mechanism hashAlg) {
        this.hashAlg = Util.requireNonNull("hashAlg", hashAlg);
    }

    public void setMaskGenerationFunction(long mgf) {
        if (mgf != 1L && mgf != 2L && mgf != 3L && mgf != 4L && mgf != 6L && mgf != 7L && mgf != 8L && mgf != 9L) {
            throw new IllegalArgumentException("Illegal value for argument\"mgf\": " + Long.toHexString(mgf));
        }
        this.mgf = mgf;
    }

    public String toString() {
        String mgfStr = this.mgf == 1L ? "SHA-1" : (this.mgf == 5L ? "SHA-224" : (this.mgf == 2L ? "SHA-256" : (this.mgf == 3L ? "SHA-384" : (this.mgf == 4L ? "SHA-512" : (this.mgf == 6L ? "SHA3-224" : (this.mgf == 7L ? "SHA3-256" : (this.mgf == 8L ? "SHA3-384" : (this.mgf == 9L ? "SHA3-512" : "<unknown>"))))))));
        return Util.concat("  Hash Algorithm: ", this.hashAlg.toString(), "\n  Mask Generation Function: ", mgfStr);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof RSAPkcsParams)) {
            return false;
        }
        RSAPkcsParams other = (RSAPkcsParams)otherObject;
        return this.hashAlg.equals(other.hashAlg) && this.mgf == other.mgf;
    }

    public int hashCode() {
        return this.hashAlg.hashCode() ^ (int)this.mgf;
    }
}

