/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.RSAPkcsParams;
import sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS;

public class RSAPkcsPssParams
extends RSAPkcsParams {
    protected long saltLength;

    public RSAPkcsPssParams(Mechanism hashAlg, long mgf, long saltLength) {
        super(hashAlg, mgf);
        this.saltLength = saltLength;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_RSA_PKCS_PSS_PARAMS params = new CK_RSA_PKCS_PSS_PARAMS();
        params.hashAlg = this.hashAlg.getMechanismCode();
        params.mgf = this.mgf;
        params.sLen = this.saltLength;
        return params;
    }

    public long getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(long saltLength) {
        this.saltLength = saltLength;
    }

    @Override
    public String toString() {
        return Util.concat(super.toString(), "\n  Salt Length (octets, dec): ", Long.toString(this.saltLength));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof RSAPkcsPssParams)) {
            return false;
        }
        RSAPkcsPssParams other = (RSAPkcsPssParams)otherObject;
        return super.equals(other) && this.saltLength == other.saltLength;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.saltLength;
    }
}

