/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.Params;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;

public class SSL3RandomDataParams
implements Params {
    protected byte[] clientRandom;
    protected byte[] serverRandom;

    public SSL3RandomDataParams(byte[] clientRandom, byte[] serverRandom) {
        this.clientRandom = Util.requireNonNull("clientRandom", clientRandom);
        this.serverRandom = Util.requireNonNull("serverRandom", serverRandom);
    }

    @Override
    public Object getPKCS11ParamsObject() {
        return new CK_SSL3_RANDOM_DATA(this.clientRandom, this.serverRandom);
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    public byte[] getServerRandom() {
        return this.serverRandom;
    }

    public void setClientRandom(byte[] clientRandom) {
        this.clientRandom = Util.requireNonNull("clientRandom", clientRandom);
    }

    public void setServerRandom(byte[] serverRandom) {
        this.serverRandom = Util.requireNonNull("serverRandom", serverRandom);
    }

    public String toString() {
        return Util.concat("  Client Random (hex): ", Util.toHex(this.clientRandom), "\n  Server Random (hex): ", Util.toHex(this.serverRandom));
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SSL3RandomDataParams)) {
            return false;
        }
        SSL3RandomDataParams other = (SSL3RandomDataParams)otherObject;
        return Arrays.equals(this.clientRandom, other.clientRandom) && Arrays.equals(this.serverRandom, other.serverRandom);
    }

    public int hashCode() {
        return Util.hashCode(this.clientRandom) ^ Util.hashCode(this.serverRandom);
    }
}

