/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.DHKeyDerivationParams;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_X9_42_DH1_DERIVE_PARAMS;

public class X942DH1KeyDerivationParams
extends DHKeyDerivationParams {
    protected byte[] otherInfo;

    public X942DH1KeyDerivationParams(long keyDerivationFunction, byte[] otherInfo, byte[] publicData) {
        super(keyDerivationFunction, publicData);
        this.otherInfo = otherInfo;
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_X9_42_DH1_DERIVE_PARAMS params = new CK_X9_42_DH1_DERIVE_PARAMS();
        params.kdf = this.kdf;
        params.pOtherInfo = this.otherInfo;
        params.pPublicData = this.publicData;
        return params;
    }

    public byte[] getOtherInfo() {
        return this.otherInfo;
    }

    public void setOtherInfo(byte[] otherInfo) {
        this.otherInfo = otherInfo;
    }

    @Override
    public String toString() {
        return Util.concat(super.toString(), "\n  Other Info: ", Util.toHex(this.otherInfo));
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X942DH1KeyDerivationParams)) {
            return false;
        }
        X942DH1KeyDerivationParams other = (X942DH1KeyDerivationParams)otherObject;
        return super.equals(other) && Arrays.equals(this.otherInfo, other.otherInfo);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Util.hashCode(this.otherInfo);
    }
}

