/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Version;
import sun.security.pkcs11.wrapper.CK_INFO;

public class Info {
    private final Version cryptokiVersion;
    private final String manufacturerID;
    private final String libraryDescription;
    private final Version libraryVersion;

    public Info(CK_INFO ckInfo) {
        Util.requireNonNull("ckInfo", ckInfo);
        this.cryptokiVersion = new Version(ckInfo.cryptokiVersion);
        this.manufacturerID = new String(ckInfo.manufacturerID);
        this.libraryDescription = new String(ckInfo.libraryDescription);
        this.libraryVersion = new Version(ckInfo.libraryVersion);
    }

    public Version getCryptokiVersion() {
        return this.cryptokiVersion;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public String getLibraryDescription() {
        return this.libraryDescription;
    }

    public Version getLibraryVersion() {
        return this.libraryVersion;
    }

    public String toString() {
        return Util.concatObjects("Cryptoki Version: ", this.cryptokiVersion, "\nManufacturerID: ", this.manufacturerID, "\nLibrary Description: ", this.libraryDescription, "\nLibrary Version: ", this.libraryVersion);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Info)) {
            return false;
        }
        Info other = (Info)otherObject;
        return this.cryptokiVersion.equals(other.cryptokiVersion) && this.manufacturerID.equals(other.manufacturerID) && this.libraryDescription.equals(other.libraryDescription) && this.libraryVersion.equals(other.libraryVersion);
    }

    public int hashCode() {
        return this.cryptokiVersion.hashCode() ^ this.manufacturerID.hashCode() ^ this.libraryDescription.hashCode() ^ this.libraryVersion.hashCode();
    }
}

